/*
 * Decompiled with CFR 0.152.
 */
package timon.common.xml;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import timon.common.xml.AbstractXmlNode;
import timon.common.xml.XmlNode;
import timon.common.xml.XmlTextNode;
import timon.common.xml.XmlUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XmlElement
extends AbstractXmlNode {
    private String tag;
    private Map<String, String> attributes = new HashMap<String, String>();
    private List<XmlNode> children = new ArrayList<XmlNode>();

    public XmlElement(String tag) {
        this(tag, null);
    }

    public XmlElement(String tag, String textContents) {
        this.tag = XmlUtil.tagEscape(tag);
        if (textContents != null) {
            this.addChild(new XmlTextNode(textContents));
        }
    }

    @Override
    public void toXmlString(String linePrefix, StringBuilder sb) {
        sb.append(linePrefix);
        sb.append("<");
        sb.append(this.tag);
        for (Map.Entry<String, String> entry : this.attributes.entrySet()) {
            sb.append(' ');
            sb.append(entry.getKey());
            sb.append("=\"");
            sb.append(XmlUtil.attributeValueEscape(entry.getValue()));
            sb.append("\"");
        }
        if (this.children.size() == 0) {
            sb.append("/>");
        } else {
            sb.append(">");
            if (!(this.children.get(0) instanceof XmlTextNode)) {
                sb.append("\n");
            }
        }
        String childLinePrefix = String.valueOf(linePrefix) + "  ";
        int n = 0;
        while (n < this.children.size()) {
            XmlNode nextChild;
            XmlNode prevChild = n > 0 ? this.children.get(n - 1) : null;
            XmlNode child = this.children.get(n);
            XmlNode xmlNode = nextChild = n < this.children.size() - 1 ? this.children.get(n + 1) : null;
            if (prevChild instanceof XmlTextNode) {
                child.toXmlString("", sb);
            } else {
                child.toXmlString(childLinePrefix, sb);
            }
            if (!(child instanceof XmlTextNode) && !(nextChild instanceof XmlTextNode)) {
                sb.append("\n");
            }
            ++n;
        }
        if (this.children.size() > 0) {
            if (!(this.children.get(this.children.size() - 1) instanceof XmlTextNode)) {
                sb.append(linePrefix);
            }
            sb.append("</");
            sb.append(this.tag);
            sb.append(">");
        }
    }

    public XmlElement addChild(String tagName) {
        return this.addChild(tagName, null);
    }

    public XmlElement addChild(String tagName, boolean textContents) {
        return this.addChild(tagName, Boolean.toString(textContents));
    }

    public XmlElement addChild(String tagName, long textContents) {
        return this.addChild(tagName, Long.toString(textContents));
    }

    public XmlElement addChild(String tagName, double textContents) {
        return this.addChild(tagName, Double.toString(textContents));
    }

    public XmlElement addChild(String tagName, String textContents) {
        return this.addChild(new XmlElement(tagName, textContents));
    }

    public XmlElement addChild(XmlElement element) {
        return (XmlElement)this.addChild((XmlNode)element);
    }

    public XmlNode addChild(XmlNode node) {
        return this.addChild(this.children.size(), node);
    }

    public XmlElement addChild(int index, String tagName) {
        return this.addChild(index, tagName, null);
    }

    public XmlElement addChild(int index, String tagName, long textContents) {
        return this.addChild(index, tagName, Long.toString(textContents));
    }

    public XmlElement addChild(int index, String tagName, String textContents) {
        return this.addChild(index, new XmlElement(tagName, textContents));
    }

    public XmlElement addChild(int index, XmlElement element) {
        return (XmlElement)this.addChild(index, (XmlNode)element);
    }

    public XmlNode addChild(int index, XmlNode node) {
        if ((index = Math.max(0, index)) >= this.children.size()) {
            this.children.add(node);
        } else {
            this.children.add(index, node);
        }
        return node;
    }

    public void removeChildren() {
        this.children.clear();
    }

    public void addAttribute(String name, long value) {
        this.addAttribute(name, Long.toString(value));
    }

    public void addAttribute(String name, double value) {
        this.addAttribute(name, Double.toString(value));
    }

    public void addAttribute(String name, boolean value) {
        this.addAttribute(name, Boolean.toString(value));
    }

    public void addAttribute(String name, String value) {
        this.attributes.put(XmlUtil.attributeNameEscape(name), value);
    }

    public void removeAttribute(String name) {
        this.attributes.remove(XmlUtil.attributeNameEscape(name));
    }

    public String getTagName() {
        return this.tag;
    }

    public List<XmlNode> getChildren() {
        return Collections.unmodifiableList(this.children);
    }

    public XmlElement getFirstElementChild() {
        for (XmlNode node : this.children) {
            if (!(node instanceof XmlElement)) continue;
            return (XmlElement)node;
        }
        return null;
    }

    public XmlElement getChild(String tagName) {
        for (XmlNode node : this.children) {
            XmlElement e;
            if (!(node instanceof XmlElement) || !(e = (XmlElement)node).getTagName().equals(tagName)) continue;
            return e;
        }
        return null;
    }

    public List<XmlElement> getChildren(String tagName) {
        ArrayList<XmlElement> list = new ArrayList<XmlElement>();
        for (XmlNode node : this.children) {
            XmlElement e;
            if (!(node instanceof XmlElement) || !(e = (XmlElement)node).getTagName().equals(tagName)) continue;
            list.add(e);
        }
        return list;
    }

    public List<XmlElement> getElementChildren() {
        ArrayList<XmlElement> list = new ArrayList<XmlElement>();
        for (XmlNode node : this.children) {
            if (!(node instanceof XmlElement)) continue;
            list.add((XmlElement)node);
        }
        return list;
    }

    public Iterable<XmlElement> elementChildren() {
        return new Iterable<XmlElement>(){

            @Override
            public Iterator<XmlElement> iterator() {
                return XmlElement.this.getElementChildren().iterator();
            }
        };
    }

    public Map<String, String> getAttributes() {
        return Collections.unmodifiableMap(this.attributes);
    }

    public String getAttribute(String name) {
        return this.attributes.get(name);
    }

    @Override
    public String getTextContent() {
        StringBuilder sb = new StringBuilder();
        for (XmlNode node : this.children) {
            sb.append(node.getTextContent());
        }
        return sb.toString();
    }
}

