/*
 * Decompiled with CFR 0.152.
 */
package timon.common.transferable;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TransferableObject
implements Transferable {
    private DataFlavor dataFlavor;
    private Object payload;

    public TransferableObject(Object transferable) {
        this.dataFlavor = TransferableObject.createDataFlavor(transferable.getClass());
        this.payload = transferable;
    }

    public static DataFlavor createDataFlavor(Class<?> c) {
        return new DataFlavor(c, String.valueOf(TransferableObject.class.getSimpleName()) + "_" + c.getSimpleName());
    }

    public static boolean isOk(Class<?> expected, DataFlavor received) {
        return TransferableObject.isOk(TransferableObject.createDataFlavor(expected), received);
    }

    public static boolean isOk(DataFlavor expected, DataFlavor received) {
        if (expected == null || received == null) {
            return false;
        }
        return expected.getRepresentationClass().isAssignableFrom(received.getRepresentationClass());
    }

    @Override
    public DataFlavor[] getTransferDataFlavors() {
        return new DataFlavor[]{this.dataFlavor};
    }

    @Override
    public boolean isDataFlavorSupported(DataFlavor flavor) {
        DataFlavor[] dataFlavorArray = this.getTransferDataFlavors();
        int n = dataFlavorArray.length;
        int n2 = 0;
        while (n2 < n) {
            DataFlavor df = dataFlavorArray[n2];
            if (TransferableObject.isOk(df, flavor)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    @Override
    public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
        if (!this.isDataFlavorSupported(flavor)) {
            throw new UnsupportedFlavorException(flavor);
        }
        return this.payload;
    }
}

