/*
 * Decompiled with CFR 0.152.
 */
package timon.common.test;

import java.awt.Color;
import java.awt.Dimension;
import javax.swing.SwingUtilities;
import timon.common.collections.Tuple2;
import timon.common.components.MessageBox;
import timon.common.components.graph.ScrollingGraph;
import timon.common.components.graph.ScrollingGraphModel;

public class GraphTest {
    public static void main(String[] args) {
        final ScrollingGraphModel<Double> model = new ScrollingGraphModel<Double>(2, 0.0, 2000.0, Double.valueOf(-100.0), Double.valueOf(100.0));
        model.setColor(1, new Color(100, 100, 255));
        ScrollingGraph graph = new ScrollingGraph("Test", model);
        graph.setPreferredSize(new Dimension(400, 300));
        MessageBox popup = new MessageBox("", graph);
        popup.addButton("Ok", "Ok");
        new Thread(new Runnable(){
            long lastTime;

            public void run() {
                this.lastTime = System.nanoTime();
                while (true) {
                    final double dt = (double)(System.nanoTime() - this.lastTime) / 1000000.0;
                    this.lastTime = System.nanoTime();
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            model.disableChangeListeners();
                            Tuple2 tuple = model.getHorizontalRange();
                            double maxX = (Double)tuple.y + dt;
                            model.setMaxX(maxX);
                            model.addValue(0, maxX, Double.valueOf(Math.random() * 100.0));
                            model.addValue(1, maxX, Double.valueOf(Math.random() * 100.0 - 50.0));
                            model.enableChangeListeners();
                            model.onChange();
                        }
                    });
                    try {
                        Thread.sleep(50L);
                    }
                    catch (InterruptedException interruptedException) {
                    }
                }
            }
        }).start();
        popup.showMessage();
        System.exit(0);
    }
}

