/*
 * Decompiled with CFR 0.152.
 */
package timon.common.settings;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.JarURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import org.xml.sax.SAXException;
import timon.common.settings.LoadingError;
import timon.common.settings.VersionUnsupportedException;
import timon.common.settings.XmlLoadingException;
import timon.common.xml.XmlElement;
import timon.common.xml.XmlReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class XmlLoader<E> {
    protected File baseDir;
    protected JarFile jarFile;
    private String xmlFileName;
    private String rootName;
    private String version;
    private List<LoadingError> errors;

    public XmlLoader(String xmlFileName, String rootName) {
        this.xmlFileName = xmlFileName;
        this.rootName = rootName;
        this.errors = new ArrayList<LoadingError>();
    }

    public abstract boolean checkVersion(String var1);

    public E load(String baseDir, String jarPath) throws XmlLoadingException {
        try {
            URL jarUrl = new URL("jar:file:" + jarPath + "!/");
            JarURLConnection jarConnection = (JarURLConnection)jarUrl.openConnection();
            return this.load(new File(baseDir), jarConnection.getJarFile());
        }
        catch (IOException ioe) {
            this.loadingError(XmlLoader.class, "Error opening archive", (Exception)ioe);
            throw new XmlLoadingException("Error opening archive");
        }
    }

    public E load(File baseDir, JarFile jarFile) throws XmlLoadingException {
        XmlElement root;
        this.baseDir = baseDir;
        this.jarFile = jarFile;
        XmlReader reader = new XmlReader();
        try {
            root = reader.read(this.getInputStream(this.xmlFileName));
        }
        catch (SAXException e) {
            throw new XmlLoadingException(e);
        }
        catch (IOException e) {
            throw new XmlLoadingException(e);
        }
        root = root.getChild(this.getRootName());
        if (root == null) {
            throw new XmlLoadingException(String.format("Root node not found (%s)", this.getRootName()));
        }
        this.version = root.getAttribute("version");
        if (!this.checkVersion(this.getVersion())) {
            throw new VersionUnsupportedException(String.format("Invalid version: %s", this.getVersion()));
        }
        return this.load(root);
    }

    protected abstract E load(XmlElement var1);

    public void addError(LoadingError le) {
        this.errors.add(le);
    }

    public void loadingError(Class<?> objectType, XmlElement xmlElement) {
        this.addError(new LoadingError(objectType, xmlElement));
    }

    public void loadingError(Class<?> objectType, XmlElement xmlElement, Exception e) {
        this.addError(new LoadingError(objectType, xmlElement, e));
    }

    public void loadingError(Class<?> objectType, XmlElement xmlElement, String description) {
        this.addError(new LoadingError(objectType, xmlElement, description));
    }

    public void loadingError(Class<?> objectType, String description, Exception e) {
        this.addError(new LoadingError(objectType, description, e));
    }

    public String getRootName() {
        return this.rootName;
    }

    public String getVersion() {
        return this.version;
    }

    public List<LoadingError> getErrors() {
        return Collections.unmodifiableList(this.errors);
    }

    protected InputStream getInputStream(String filename) throws IOException {
        ZipEntry entry;
        File file;
        if (this.baseDir != null && this.baseDir.exists() && (file = new File(String.valueOf(this.baseDir.getAbsolutePath()) + "/" + filename)).exists()) {
            return new FileInputStream(file);
        }
        ZipEntry zipEntry = entry = this.jarFile != null ? this.jarFile.getEntry(filename) : null;
        if (entry == null) {
            throw new FileNotFoundException(filename);
        }
        return this.jarFile.getInputStream(entry);
    }
}

