/*
 * Decompiled with CFR 0.152.
 */
package timon.common.settings;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import timon.common.xml.XmlElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LoadingError {
    private Class<?> objectType;
    private XmlElement xmlElement;
    private String description;
    private String exception;

    public LoadingError(Class<?> objectType, XmlElement xmlElement) {
        this(objectType, xmlElement, "Unknown Error!");
    }

    public LoadingError(Class<?> objectType, XmlElement xmlElement, Exception e) {
        this(objectType, xmlElement, e.toString(), e);
    }

    public LoadingError(Class<?> objectType, XmlElement xmlElement, String description) {
        this(objectType, xmlElement, description, null);
    }

    public LoadingError(Class<?> objectType, String description, Exception e) {
        this(objectType, null, description, e);
    }

    public LoadingError(Class<?> objectType, XmlElement xmlElement, String description, Exception e) {
        this.objectType = objectType;
        this.xmlElement = xmlElement;
        this.description = description;
        this.exception = e != null ? LoadingError.getStackTrace(e) : null;
    }

    public String toString() {
        return String.format("Error loading %s: %s", this.objectType.getName(), this.description);
    }

    public XmlElement toXml() {
        XmlElement element = new XmlElement("error");
        element.addChild("objectType", this.objectType.getSimpleName());
        element.addChild("description", this.description);
        if (this.exception != null) {
            element.addChild("exception", this.exception);
        }
        if (this.xmlElement != null) {
            element.addChild("xmlLocation").addChild(this.xmlElement);
        }
        return element;
    }

    protected static String getStackTrace(Exception e) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        e.printStackTrace(pw);
        String result = sw.getBuffer().toString();
        try {
            sw.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return result;
    }
}

