/*
 * Decompiled with CFR 0.152.
 */
package timon.common.settings;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Properties;
import timon.common.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractPreferences {
    protected HashMap<String, Object> data;
    private String appdataPath;
    private String filename;
    private boolean loadingFailed;

    protected AbstractPreferences(String appdataPath, String filename) {
        this.appdataPath = appdataPath != null ? appdataPath : "";
        this.filename = filename;
        this.data = new HashMap();
        this.init();
        this.load();
    }

    protected abstract void init();

    private void load() {
        try {
            File file = new File(String.valueOf(this.appdataPath) + this.filename);
            if (!file.exists()) {
                this.save();
            }
            Properties properties = new Properties();
            properties.loadFromXML(new FileInputStream(file));
            for (Object key : properties.keySet()) {
                this.fileToMem(key.toString(), properties);
            }
            this.loadingFailed = false;
        }
        catch (Exception e) {
            Log.warning(e);
            this.loadingFailed = true;
        }
    }

    public void save() {
        if (this.loadingFailed) {
            Log.warning("Loading of Preferences failed, saving undesirable and thus aborted.");
        } else {
            try {
                File file = new File(String.valueOf(this.appdataPath) + this.filename);
                file.createNewFile();
                Properties properties = new Properties();
                for (String key : this.data.keySet()) {
                    this.memToFile(key, properties);
                }
                properties.storeToXML(new FileOutputStream(file), new Date().toString());
            }
            catch (Exception e) {
                Log.warning(e);
            }
        }
    }

    public Object getProperty(String id, Object defaultValue) {
        Object result = this.data.get(id);
        if (result != null) {
            return result;
        }
        return defaultValue;
    }

    public Collection<Object> getProperties() {
        return this.data.values();
    }

    public void setProperty(String id, Object value) {
        this.data.put(id, value);
    }

    public void fileToMem(String id, Properties properties) {
        String value = properties.getProperty(id);
        if (value != null) {
            Object type = this.data.get(id);
            this.data.put(id, this.fromString(type != null ? type.getClass() : Object.class, value));
        }
    }

    protected Object fromString(Class<?> type, String value) {
        if (type == Integer.class) {
            return Integer.parseInt(value);
        }
        if (type == Float.class) {
            return Float.valueOf(Float.parseFloat(value));
        }
        if (type == Boolean.class) {
            return Boolean.parseBoolean(value);
        }
        return value;
    }

    public void memToFile(String id, Properties properties) {
        properties.setProperty(id, "" + this.data.get(id));
    }
}

