/*
 * Decompiled with CFR 0.152.
 */
package timon.common.io;

import java.io.EOFException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class LittleEndianInputStream
extends FilterInputStream {
    public LittleEndianInputStream(InputStream in) {
        super(in);
    }

    public static final long readLE(InputStream in, int bytes) throws IOException {
        long result = 0L;
        int n = 0;
        while (n < bytes) {
            int r = in.read();
            if (r >= 0) {
                result += (long)(r << (n << 3));
            } else {
                throw new EOFException();
            }
            ++n;
        }
        return result;
    }

    public short readShort() throws IOException {
        return (short)LittleEndianInputStream.readLE(this, 2);
    }

    public int readInt() throws IOException {
        return (int)LittleEndianInputStream.readLE(this, 4);
    }

    public long readLong() throws IOException {
        return LittleEndianInputStream.readLE(this, 8);
    }

    public short readUnsigned() throws IOException {
        return (short)(LittleEndianInputStream.readLE(this, 1) & 0xFFL);
    }

    public int readUShort() throws IOException {
        return (int)(LittleEndianInputStream.readLE(this, 2) & 0xFFFFL);
    }

    public long readUInt() throws IOException {
        return LittleEndianInputStream.readLE(this, 4) & 0xFFFFFFFFL;
    }
}

