/*
 * Decompiled with CFR 0.152.
 */
package timon.common.io;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.CRC32;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import timon.common.Log;
import timon.common.StringUtil;
import timon.common.SystemUtil;
import timon.common.collections.Tuple2;
import timon.common.io.FileOp;
import timon.common.io.FileOpListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileUtil {
    private static final char[] illegalFilenameChars = "?[]/\\=+<>:;\",*|".toCharArray();

    public static File copyFolder(File src, File dstFolder) throws IOException {
        return FileUtil.copyFolder(src, dstFolder, null);
    }

    public static File copyFolder(File src, File dstFolder, FileOpListener fol) throws IOException {
        if (!src.exists()) {
            throw new IOException("File doesn't exist: " + src.getAbsolutePath());
        }
        HashMap<String, File> fileMap = new HashMap<String, File>();
        FileUtil.collectFiles(fileMap, src, true);
        return FileUtil.copyFiles(fileMap, dstFolder, fol);
    }

    public static File copyFolderContents(File src, File dstFolder) throws IOException {
        return FileUtil.copyFolderContents(src, dstFolder, null);
    }

    public static File copyFolderContents(File src, File dstFolder, FileOpListener fol) throws IOException {
        if (!src.exists()) {
            throw new IOException("File doesn't exist: " + src.getAbsolutePath());
        }
        HashMap<String, File> fileMap = new HashMap<String, File>();
        FileUtil.collectFiles(fileMap, src, false);
        return FileUtil.copyFiles(fileMap, dstFolder, fol);
    }

    public static File copyFiles(Map<String, File> fileMap, File dstFolder, FileOpListener fol) throws IOException {
        int t = 0;
        for (Map.Entry<String, File> entry : fileMap.entrySet()) {
            String relPath = entry.getKey();
            File f = entry.getValue();
            ++t;
            if (fol != null) {
                fol.onOpStart(relPath, f, t, fileMap.size());
            }
            File dst = new File(String.valueOf(dstFolder.getAbsolutePath()) + File.separator + relPath);
            if (f.isDirectory()) {
                dst.mkdirs();
                continue;
            }
            FileUtil.copyFile(f, dst);
        }
        if (fol != null) {
            fol.onFinished(fileMap.size());
        }
        return dstFolder;
    }

    public static boolean copyFile(File srcFile, File dst) {
        try {
            dst.delete();
            if (dst.isDirectory()) {
                dst.mkdirs();
                dst = new File(String.valueOf(dst.getAbsolutePath()) + "/" + srcFile.getName());
            } else {
                dst.getParentFile().mkdirs();
                dst.createNewFile();
            }
            if (System.getProperty("os.name").toLowerCase().indexOf("windows") >= 0 && StringUtil.isASCII(srcFile.getAbsolutePath()) && StringUtil.isASCII(dst.getAbsolutePath())) {
                Runtime runtime = Runtime.getRuntime();
                try {
                    Process p = runtime.exec(new String[]{"cmd", "/C", "copy /Y \"" + srcFile.getAbsolutePath().replace('/', '\\') + "\" \"" + dst.getAbsolutePath().replace('/', '\\') + "\""});
                    SystemUtil.waitFor(p);
                }
                catch (IOException e) {
                    Log.error(e);
                }
            } else {
                FileChannel ic = new FileInputStream(srcFile).getChannel();
                FileChannel oc = new FileOutputStream(dst).getChannel();
                long pos = 0L;
                long chunkL = 0x400000L;
                long size = ic.size();
                while (pos < size) {
                    long r = ic.transferTo(pos, chunkL, oc);
                    if (r <= 0L) {
                        throw new IOException("transferTo returned -1");
                    }
                    pos += r;
                }
                ic.close();
                oc.close();
            }
            return true;
        }
        catch (IOException ioe) {
            Log.error(ioe);
            return false;
        }
    }

    public static void deleteFolder(File file) {
        FileUtil.deleteFolder(file, null);
    }

    public static void deleteFolder(File file, FileOpListener fol) {
        if (System.getProperty("os.name").toLowerCase().indexOf("windows") >= 0 && StringUtil.isASCII(file.getAbsolutePath())) {
            Runtime runtime = Runtime.getRuntime();
            try {
                Process p = runtime.exec(new String[]{"cmd", "/C", "rmdir /S /Q \"" + file.getAbsolutePath().replace('/', '\\') + "\""});
                SystemUtil.waitFor(p);
            }
            catch (IOException e) {
                Log.error(e);
            }
            if (fol != null) {
                fol.onFinished(0);
            }
        } else {
            HashMap<String, File> fileMap = new HashMap<String, File>();
            FileUtil.collectFiles(fileMap, file, true);
            FileUtil.deleteFiles(fileMap, fol, false);
            if (fol != null) {
                fol.onFinished(fileMap.size());
            }
        }
    }

    public static void deleteFiles(Map<String, File> fileMap, FileOpListener fol) {
        FileUtil.deleteFiles(fileMap, fol, true);
    }

    private static void deleteFiles(Map<String, File> fileMap, FileOpListener fol, boolean generateFinishEvent) {
        int t = 0;
        for (Map.Entry<String, File> entry : fileMap.entrySet()) {
            String relPath = entry.getKey();
            File f = entry.getValue();
            ++t;
            if (fol != null) {
                fol.onOpStart(relPath, f, t, fileMap.size());
            }
            f.delete();
            FileUtil.deleteEmptyFolders(f.getParentFile());
        }
        if (generateFinishEvent && fol != null) {
            fol.onFinished(fileMap.size());
        }
    }

    public static void collectFiles(Map<String, File> map, File file, boolean includeRootFolder) {
        FileUtil.collectFiles(map, file, includeRootFolder, false);
    }

    public static void collectFiles(Map<String, File> map, File file, boolean includeRootFolder, boolean collectFolders) {
        if (!file.isDirectory()) {
            map.put(file.getName(), file);
        } else if (includeRootFolder) {
            FileUtil.collectFiles(map, file, "", collectFolders);
        } else {
            File[] fileArray = file.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File f = fileArray[n2];
                FileUtil.collectFiles(map, f, "", collectFolders);
                ++n2;
            }
        }
    }

    private static void collectFiles(Map<String, File> map, File file, String relPath, boolean collectFolders) {
        String path = relPath.length() > 0 ? String.valueOf(relPath) + '/' + file.getName() : file.getName();
        if (file.isDirectory()) {
            if (collectFolders) {
                map.put(path, file);
            }
            File[] fileArray = file.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File f = fileArray[n2];
                FileUtil.collectFiles(map, f, path, collectFolders);
                ++n2;
            }
        } else {
            map.put(path, file);
        }
    }

    public static void showCopy(File f1, File f2, String formatString, FileOpListener fol) {
        if (f2 == null) {
            throw new IllegalArgumentException("Can't copy to a null folder");
        }
        FileUtil.show(f1, f2, formatString, fol);
    }

    public static void showCopy(Map<String, File> fileMap, File f2, String formatString, FileOpListener fol) {
        if (f2 == null) {
            throw new IllegalArgumentException("Can't copy to a null folder");
        }
        FileUtil.show(fileMap, f2, formatString, fol);
    }

    public static void showDelete(File f, String formatString, FileOpListener fol) {
        FileUtil.show(f, null, formatString, fol);
    }

    public static void showDelete(Map<String, File> fileMap, String formatString, FileOpListener fol) {
        FileUtil.show(fileMap, null, formatString, fol);
    }

    public static void show(FileOp op, String formatString, FileOpListener fol) {
        FileUtil.show(op, null, formatString, fol);
    }

    private static void show(final Object f1, final File f2, final String formatString, final FileOpListener fol) {
        final JLabel messageLabel = new JLabel("Initializing...");
        final JProgressBar progressBar = new JProgressBar();
        JPanel panel = new JPanel(new BorderLayout(5, 5));
        panel.setBorder(new EmptyBorder(10, 10, 10, 10));
        panel.add((Component)messageLabel, "Center");
        panel.add((Component)progressBar, "South");
        final JDialog dialog = new JDialog();
        dialog.setResizable(false);
        dialog.setDefaultCloseOperation(0);
        dialog.setAlwaysOnTop(true);
        panel.setPreferredSize(new Dimension(400, 60));
        dialog.add(panel);
        dialog.pack();
        dialog.setLocationRelativeTo(null);
        dialog.setVisible(true);
        final FileOpListener progressListener = new FileOpListener(){

            public void onOpStart(final String relPath, final File file, final int fileNum, final int fileCount) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        if (fileCount == 0) {
                            progressBar.setIndeterminate(true);
                        } else {
                            progressBar.setIndeterminate(false);
                            progressBar.setMaximum(fileCount);
                            progressBar.setValue(fileNum);
                        }
                        String p = relPath.substring(0, Math.min(32, relPath.length()));
                        messageLabel.setText(String.format(formatString, fileNum, fileCount, p));
                        if (fol != null) {
                            fol.onOpStart(relPath, file, fileNum, fileCount);
                        }
                    }
                });
            }

            public void onFinished(final int fileCount) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        if (fol != null) {
                            fol.onFinished(fileCount);
                        }
                    }
                });
            }
        };
        Thread t = new Thread(new Runnable(){

            public void run() {
                block9: {
                    try {
                        if (f1 instanceof File) {
                            if (f2 != null) {
                                FileUtil.copyFolder((File)f1, f2, progressListener);
                            } else {
                                FileUtil.deleteFolder((File)f1, progressListener);
                            }
                            break block9;
                        }
                        if (f1 instanceof Map) {
                            if (f2 != null) {
                                FileUtil.copyFiles((Map)f1, f2, progressListener);
                            } else {
                                FileUtil.deleteFiles((Map)f1, progressListener);
                            }
                            break block9;
                        }
                        if (f1 instanceof FileOp) {
                            ((FileOp)f1).run(progressListener);
                            break block9;
                        }
                        throw new IllegalArgumentException("Invalid argument type: " + (f1 != null ? f1.getClass().getName() : null));
                    }
                    catch (Exception e) {
                        Log.showError(e);
                    }
                }
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        dialog.dispose();
                    }
                });
            }
        });
        t.start();
    }

    public static Tuple2<Integer, Long> calculateFolderSize(File file) {
        Tuple2<Integer, Long> tuple = new Tuple2<Integer, Long>();
        tuple.x = 0;
        tuple.y = 0L;
        if (file.isDirectory()) {
            File[] fileArray = file.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File f = fileArray[n2];
                Tuple2<Integer, Long> t = FileUtil.calculateFolderSize(f);
                tuple.x = (Integer)tuple.x + (Integer)t.x;
                tuple.y = (Long)tuple.y + (Long)t.y;
                ++n2;
            }
        } else {
            tuple.x = 1;
            tuple.y = file.length();
        }
        return tuple;
    }

    public static String toSizeString(long filesize) {
        String[] units = new String[]{"B", "KB", "MB", "GB", "TB"};
        int index = 0;
        long remainder = filesize;
        while (remainder >= 1024L && index < units.length - 1) {
            remainder >>= 10;
            ++index;
        }
        double fraq = (double)(filesize - (remainder << 10 * index)) / Math.pow(1024.0, index);
        return String.format("%.2f%s", (double)remainder + fraq, units[index]);
    }

    public static void deleteEmptyFolders(File folder) {
        if (folder.isDirectory()) {
            boolean empty;
            File[] fileArray = folder.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File f = fileArray[n2];
                if (f.isDirectory()) {
                    FileUtil.deleteEmptyFolders(f);
                }
                ++n2;
            }
            boolean bl = empty = folder.list().length == 0;
            if (empty) {
                folder.delete();
            }
        }
    }

    public static String read(String filename) throws IOException {
        return FileUtil.read(new File(filename));
    }

    public static String read(File file) throws IOException {
        FileInputStream fin = new FileInputStream(file);
        String result = null;
        try {
            result = FileUtil.read(fin);
            fin.close();
        }
        finally {
            fin.close();
        }
        return result;
    }

    public static String read(InputStream in) throws IOException {
        String line;
        StringBuilder sb = new StringBuilder();
        BufferedReader bufferedIn = new BufferedReader(new InputStreamReader(in, "UTF-8"));
        while ((line = bufferedIn.readLine()) != null) {
            sb.append(line);
            sb.append('\n');
        }
        bufferedIn.close();
        return sb.toString();
    }

    public static byte[] readBytes(File file) throws IOException {
        byte[] result = new byte[(int)file.length()];
        FileInputStream fin = new FileInputStream(file);
        fin.read(result);
        fin.close();
        return result;
    }

    public static byte[] readFully(InputStream in) throws IOException {
        int bsize = 4096;
        ArrayList<byte[]> list = new ArrayList<byte[]>();
        list.add(new byte[4096]);
        int offset = 0;
        while (true) {
            int read;
            byte[] buffer;
            if (offset == (buffer = (byte[])list.get(list.size() - 1)).length) {
                list.add(new byte[4096]);
                offset = 0;
                buffer = (byte[])list.get(list.size() - 1);
            }
            if ((read = in.read(buffer, offset, buffer.length - offset)) == -1) break;
            offset += read;
        }
        int len = (list.size() - 1) * 4096 + offset;
        byte[] result = new byte[len];
        int t = 0;
        int n = 0;
        while (n < list.size() - 1) {
            System.arraycopy(list.get(n), 0, result, t, 4096);
            t += 4096;
            ++n;
        }
        System.arraycopy(list.get(list.size() - 1), 0, result, t, offset);
        return result;
    }

    public static int readFromStream(byte[] out, InputStream in) throws IOException {
        int read;
        int offset = 0;
        while ((read = in.read(out, offset, out.length - offset)) >= 0) {
            offset += read;
        }
        return offset;
    }

    public static void write(String filename, String content) throws IOException {
        FileUtil.write(new File(filename), content);
    }

    public static void write(File file, String content) throws IOException {
        FileUtil.write(file, content.getBytes("UTF-8"));
    }

    public static void write(File file, byte[] bytes) throws IOException {
        FileUtil.write(file, bytes, 0, bytes.length);
    }

    public static void write(File file, byte[] bytes, int offset, int len) throws IOException {
        ByteArrayInputStream bin = new ByteArrayInputStream(bytes, offset, len);
        FileUtil.write(file, (InputStream)bin);
        bin.close();
    }

    public static void write(String filename, InputStream in) throws IOException {
        FileUtil.write(new File(filename), in);
    }

    public static void write(File file, InputStream in) throws IOException {
        if (!file.exists() && file.getParentFile() != null) {
            file.getParentFile().mkdirs();
        }
        FileOutputStream fout = new FileOutputStream(file);
        FileUtil.write(fout, in);
        fout.close();
    }

    public static void write(OutputStream out, InputStream in) throws IOException {
        int read;
        int bufferL = 16384;
        byte[] buffer = new byte[bufferL];
        while ((read = in.read(buffer, 0, bufferL)) >= 0) {
            out.write(buffer, 0, read);
        }
        out.flush();
    }

    public static String getExtension(String path) {
        int index = path.lastIndexOf(46);
        if (index > 0 && index < path.length()) {
            return path.substring(index + 1, path.length());
        }
        return "";
    }

    public static String stripExtension(String path) {
        int index = path.lastIndexOf(46);
        if (index > 0 && index < path.length()) {
            return path.substring(0, index);
        }
        return path;
    }

    public static boolean isValidFilename(String filename) {
        if (filename.trim().length() == 0) {
            return false;
        }
        int[] string = StringUtil.toUnicodeArray(filename);
        int n = 0;
        while (n < string.length) {
            int x = 0;
            while (x < illegalFilenameChars.length) {
                if (string[n] == illegalFilenameChars[x]) {
                    return false;
                }
                ++x;
            }
            ++n;
        }
        return true;
    }

    public static boolean isValidFATFilename(String filename) {
        if (!FileUtil.isValidFilename(filename)) {
            return false;
        }
        int[] string = StringUtil.toUnicodeArray(filename);
        int n = 0;
        while (n < string.length) {
            if (string[n] > 255) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public static String toValidASCIIFilename(String filename) {
        StringBuilder sb = new StringBuilder();
        int[] string = StringUtil.toUnicodeArray(filename);
        int n = 0;
        while (n < string.length) {
            boolean illegal;
            boolean bl = illegal = string[n] == 35 || string[n] > 127;
            if (!illegal) {
                int x = 0;
                while (x < illegalFilenameChars.length) {
                    if (string[n] == illegalFilenameChars[x]) {
                        illegal = true;
                        break;
                    }
                    ++x;
                }
            }
            if (illegal) {
                sb.append(String.format("#%04x", string[n]));
            } else {
                sb.append((char)string[n]);
            }
            ++n;
        }
        return sb.toString();
    }

    public static void zip(File folder, File zipFile, FileOpListener fol) throws IOException {
        FileUtil.zip(new File[]{folder}, zipFile, fol);
    }

    public static void zip(File[] folders, File zipFile, FileOpListener fol) throws IOException {
        HashMap<String, File> files = new HashMap<String, File>();
        File[] fileArray = folders;
        int n = folders.length;
        int n2 = 0;
        while (n2 < n) {
            File folder = fileArray[n2];
            if (folder.exists()) {
                FileUtil.collectFiles(files, folder, true);
            }
            ++n2;
        }
        if (files.size() != 0) {
            FileUtil.zip(files, zipFile, fol);
        }
    }

    public static void zip(Map<String, File> files, File zipFile, FileOpListener fol) throws IOException {
        ZipOutputStream zout = new ZipOutputStream(new FileOutputStream(zipFile));
        zout.setMethod(0);
        int t = 1;
        for (Map.Entry<String, File> entry : files.entrySet()) {
            if (fol != null) {
                fol.onOpStart(entry.getKey(), entry.getValue(), t, files.size());
            }
            FileUtil.addToUncompressedZip(zout, entry.getKey(), entry.getValue());
            ++t;
        }
        zout.flush();
        zout.close();
        if (fol != null) {
            fol.onFinished(files.size());
        }
    }

    public static void addToUncompressedZip(ZipOutputStream zout, String prefix, File file) throws IOException {
        if (file.isDirectory()) {
            FileUtil.addToUncompressedZip(zout, String.valueOf(prefix) + "/", new byte[0], 0, 0);
        } else {
            byte[] data = FileUtil.readBytes(file);
            FileUtil.addToUncompressedZip(zout, prefix, data, 0, data.length);
        }
    }

    public static void addToUncompressedZip(ZipOutputStream zout, String prefix, byte[] data, int offset, int len) throws IOException {
        ZipEntry entry = new ZipEntry(prefix);
        entry.setMethod(0);
        entry.setSize(len);
        entry.setCompressedSize(len);
        CRC32 crc = new CRC32();
        crc.update(data, offset, len);
        entry.setCrc(crc.getValue());
        zout.putNextEntry(entry);
        zout.write(data, offset, len);
        zout.flush();
        zout.closeEntry();
    }

    public static byte[] unzip(byte[] data) throws IOException {
        InflaterInputStream zin = new InflaterInputStream(new ByteArrayInputStream(data));
        try {
            byte[] byArray = FileUtil.readFully(zin);
            return byArray;
        }
        finally {
            zin.close();
        }
    }

    public static int unzip(InputStream in, byte[] out) throws IOException {
        return FileUtil.unzip(in, out, -1);
    }

    public static int unzip(InputStream in, byte[] out, int inL) throws IOException {
        Inflater inf = new Inflater();
        int read = 0;
        int inflated = 0;
        byte[] readBuffer = new byte[262144];
        try {
            while (true) {
                int r;
                int i;
                if ((i = inf.inflate(out, inflated, out.length - inflated)) > 0) {
                    inflated += i;
                    continue;
                }
                if (inf.finished() || inf.needsDictionary() || inL >= 0 && read >= inL) {
                    return inflated;
                }
                if (!inf.needsInput()) continue;
                int readLeft = readBuffer.length;
                if (inL >= 0 && inL - read < readLeft) {
                    readLeft = inL - read;
                }
                if ((r = in.read(readBuffer, 0, readLeft)) == -1) {
                    throw new EOFException("Unexpected end of ZLIB input stream");
                }
                read += r;
                inf.setInput(readBuffer, 0, r);
            }
        }
        catch (DataFormatException e) {
            throw new IOException(e);
        }
    }

    public static int unzip(InputStream in, OutputStream out) throws IOException {
        return FileUtil.unzip(in, out, -1);
    }

    public static int unzip(InputStream in, OutputStream out, int inL) throws IOException {
        Inflater inf = new Inflater();
        int read = 0;
        int inflated = 0;
        byte[] infBuffer = new byte[262144];
        byte[] readBuffer = new byte[262144];
        try {
            while (true) {
                int r;
                int i;
                if ((i = inf.inflate(infBuffer, 0, infBuffer.length)) > 0) {
                    inflated += i;
                    out.write(infBuffer, 0, i);
                    continue;
                }
                if (inf.finished() || inf.needsDictionary() || inL >= 0 && read >= inL) {
                    return inflated;
                }
                if (!inf.needsInput()) continue;
                int readLeft = readBuffer.length;
                if (inL >= 0 && inL - read < readLeft) {
                    readLeft = inL - read;
                }
                if ((r = in.read(readBuffer, 0, readLeft)) == -1) {
                    throw new EOFException("Unexpected end of ZLIB input stream");
                }
                read += r;
                inf.setInput(readBuffer, 0, r);
            }
        }
        catch (DataFormatException e) {
            throw new IOException(e);
        }
    }
}

