/*
 * Decompiled with CFR 0.152.
 */
package timon.common.io;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import timon.common.Log;
import timon.common.components.progress.ProgressListener;
import timon.common.io.FileTask;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BatchProcess {
    private int threads = 1;
    private int threadPriority = 5;
    private int taskSize = 8;
    private List<ProgressListener> listeners = new ArrayList<ProgressListener>(2);
    private ExecutorService executor;
    private volatile int progress;
    private int maxProgress;

    public void addProgressListener(ProgressListener pl) {
        this.listeners.add(pl);
    }

    public void removeProgressListener(ProgressListener pl) {
        this.listeners.remove(pl);
    }

    public void run(Map<String, File> fileMap, FileTask ftask) throws InterruptedException {
        this.start(fileMap, ftask);
        this.stop();
    }

    public void start(Map<String, File> fileMap, FileTask ftask) {
        try {
            this.stop();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.executor = Executors.newFixedThreadPool(this.threads, new ThreadFactory(){

            public Thread newThread(Runnable r) {
                Thread t = new Thread(r);
                t.setPriority(BatchProcess.this.threadPriority);
                return t;
            }
        });
        this.progress = 0;
        this.maxProgress = fileMap.size();
        int stepSize = this.taskSize;
        if (stepSize * this.threads > fileMap.size()) {
            stepSize = Math.max(1, fileMap.size() / this.threads);
        }
        ProgressListener[] ls = this.listeners.toArray(new ProgressListener[this.listeners.size()]);
        Iterator<Map.Entry<String, File>> i = fileMap.entrySet().iterator();
        while (i.hasNext()) {
            String[] relpaths = new String[stepSize];
            File[] files = new File[stepSize];
            int t = 0;
            while (t < stepSize && i.hasNext()) {
                Map.Entry<String, File> entry = i.next();
                relpaths[t] = entry.getKey();
                files[t] = entry.getValue();
                ++t;
            }
            this.executor.submit(new Task(ftask, relpaths, files, t, ls));
        }
    }

    public void stop() throws InterruptedException {
        if (this.executor != null) {
            ProgressListener[] ls;
            this.executor.shutdown();
            this.executor.awaitTermination(Integer.MAX_VALUE, TimeUnit.SECONDS);
            ProgressListener[] progressListenerArray = ls = this.listeners.toArray(new ProgressListener[this.listeners.size()]);
            int n = ls.length;
            int n2 = 0;
            while (n2 < n) {
                ProgressListener pl = progressListenerArray[n2];
                pl.onFinished("Finished");
                ++n2;
            }
            this.executor = null;
        }
    }

    public int getThreads() {
        return this.threads;
    }

    public int getThreadPriority() {
        return this.threadPriority;
    }

    public int getTaskSize() {
        return this.taskSize;
    }

    public void setThreads(int t) {
        if (t <= 0) {
            t = Runtime.getRuntime().availableProcessors();
        }
        this.threads = t;
    }

    public void setThreadPriority(int p) {
        this.threadPriority = p;
    }

    public void setTaskSize(int ts) {
        this.taskSize = ts;
    }

    private class Task
    implements Runnable {
        private final FileTask ftask;
        private final String[] relpaths;
        private final File[] files;
        private final int len;
        private final ProgressListener[] listeners;

        public Task(FileTask ft, String[] rps, File[] fs, int t, ProgressListener[] pls) {
            this.ftask = ft;
            this.relpaths = rps;
            this.files = fs;
            this.len = t;
            this.listeners = pls;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            int n = 0;
            while (n < this.len) {
                block15: {
                    boolean ok = false;
                    try {
                        this.ftask.processFile(this.relpaths[n], this.files[n]);
                        ok = true;
                    }
                    catch (IOException e) {
                        Log.warning(e);
                        if (!ok) {
                            Log.error("Unknown error processing task: " + n + " " + this.len + " " + this.relpaths[n]);
                        }
                        break block15;
                    }
                    catch (RuntimeException re) {
                        try {
                            Log.warning(re);
                            break block15;
                        }
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                        finally {
                            if (!ok) {
                                Log.error("Unknown error processing task: " + n + " " + this.len + " " + this.relpaths[n]);
                            }
                        }
                    }
                    if (ok) break block15;
                    Log.error("Unknown error processing task: " + n + " " + this.len + " " + this.relpaths[n]);
                }
                ++n;
            }
            if (this.listeners != null && this.listeners.length > 0 && this.len > 0) {
                BatchProcess batchProcess = BatchProcess.this;
                synchronized (batchProcess) {
                    BatchProcess batchProcess2 = BatchProcess.this;
                    batchProcess2.progress = batchProcess2.progress + this.len;
                    ProgressListener[] progressListenerArray = this.listeners;
                    int n2 = this.listeners.length;
                    int n3 = 0;
                    while (n3 < n2) {
                        ProgressListener pl = progressListenerArray[n3];
                        pl.onProgress(BatchProcess.this.progress, BatchProcess.this.maxProgress, "");
                        ++n3;
                    }
                }
            }
        }
    }
}

