/*
 * Decompiled with CFR 0.152.
 */
package timon.common.components.property.editor;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import timon.common.StringUtil;
import timon.common.components.TColorChooser;
import timon.common.components.property.editor.CompositePropertyEditor;
import timon.common.internal.Icons;

public class ColorPropertyEditor
extends CompositePropertyEditor {
    private Color selectedColor;
    private JLabel label = new JLabel();
    private JTextField textField = new JTextField();
    private JButton browseButton;

    public ColorPropertyEditor() {
        this.textField.setBorder(null);
        this.textField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                try {
                    String text = ColorPropertyEditor.this.textField.getText().trim();
                    if (text.startsWith("#")) {
                        ColorPropertyEditor.this.selectedColor = new Color(Integer.parseInt(text.substring(1), 16) | 0xFF000000);
                    } else {
                        ColorPropertyEditor.this.selectedColor = new Color(Integer.parseInt(text, 10) | 0xFF000000);
                    }
                    ColorPropertyEditor.this.stopCellEditing();
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        });
        this.browseButton = new JButton(Icons.get("browseImage"));
        this.browseButton.setPreferredSize(new Dimension(17, 17));
        this.browseButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                TColorChooser chooser = new TColorChooser(ColorPropertyEditor.this.selectedColor);
                Color result = chooser.showMessage(ColorPropertyEditor.this.getPanel(), "");
                if (result != null) {
                    ColorPropertyEditor.this.selectedColor = result;
                    ColorPropertyEditor.this.updateLabel();
                }
                ColorPropertyEditor.this.stopCellEditing();
            }
        });
    }

    protected JPanel createPanel() {
        JPanel panel = new JPanel(new BorderLayout(2, 0));
        panel.setBorder(new EmptyBorder(0, 1, 0, 0));
        panel.add((Component)this.label, "West");
        panel.add((Component)this.textField, "Center");
        panel.add((Component)this.browseButton, "East");
        return panel;
    }

    protected void updateLabel() {
        if (this.selectedColor != null) {
            String color = Integer.toHexString(this.selectedColor.getRGB() & 0xFFFFFF);
            this.label.setText("<html><div width='13' height='13' style='background-color: #" + color + ";'></div></html>");
        } else {
            this.label.setText("");
        }
    }

    public Object getCellEditorValue() {
        return this.selectedColor;
    }

    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        this.textField.setBackground(table.getBackground());
        return super.getTableCellEditorComponent(table, value, isSelected, row, column);
    }

    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        this.textField.setBackground(this.getPanel().getBackground());
        return super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
    }

    public void setValue(Object value) {
        this.selectedColor = value instanceof Color ? (Color)value : null;
        String text = Integer.toHexString(this.selectedColor.getRGB() & 0xFFFFFF);
        this.textField.setText("#" + StringUtil.repeatString("0", 6 - text.length()) + text.toUpperCase());
        this.updateLabel();
    }
}

