/*
 * Decompiled with CFR 0.152.
 */
package timon.common.components.property.editor;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextField;
import timon.common.components.BrowseField;
import timon.common.components.property.editor.CompositePropertyEditor;
import timon.common.internal.Text;

public abstract class BrowsePropertyEditor
extends CompositePropertyEditor {
    public static final String PREFIX = "components.property.editor.BrowsePropertyEditor.";
    private JTextField textField;
    private Object value;

    public BrowsePropertyEditor(final JTextField textField) {
        this.textField = textField;
        textField.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
                textField.selectAll();
            }

            public void focusLost(FocusEvent e) {
            }
        });
        textField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                BrowsePropertyEditor.this.value = textField.getText();
                BrowsePropertyEditor.this.stopCellEditing();
            }
        });
        textField.setEditable(false);
    }

    public abstract Object showBrowsePopup(Object var1);

    protected String getDefaultPopupTitle() {
        return Text.get("components.property.editor.BrowsePropertyEditor.popupTitle");
    }

    protected JPanel createPanel() {
        JPanel panel = new JPanel();
        panel.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent arg0) {
                BrowsePropertyEditor.this.textField.selectAll();
            }

            public void focusLost(FocusEvent arg0) {
            }
        });
        BrowseField browseField = new BrowseField(this.textField);
        browseField.getButton().addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                BrowsePropertyEditor.this.setValue(BrowsePropertyEditor.this.showBrowsePopup(BrowsePropertyEditor.this.getCellEditorValue()));
                BrowsePropertyEditor.this.stopCellEditing();
            }
        });
        panel.setLayout(new BorderLayout());
        panel.add((Component)browseField, "Center");
        return panel;
    }

    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        if (this.textField.isEditable()) {
            this.textField.setBackground(table.getBackground());
        } else {
            this.textField.setBackground(this.getPanel().getBackground());
        }
        return super.getTableCellEditorComponent(table, value, isSelected, row, column);
    }

    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        this.textField.setBackground(this.getPanel().getBackground());
        return super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
    }

    public Object getCellEditorValue() {
        return this.value;
    }

    public void setValue(Object v) {
        this.value = v;
        this.textField.setText(v != null ? String.valueOf(v) : "");
    }
}

