/*
 * Decompiled with CFR 0.152.
 */
package timon.common.components.property;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import timon.common.components.property.CompositeProperty;
import timon.common.components.property.Property;
import timon.common.components.property.PropertyModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertyTableModel
extends AbstractTableModel {
    private PropertyModel model;
    private List<Property2> properties = new ArrayList<Property2>();

    public void onModelChanged() {
        HashSet<String> expanded = new HashSet<String>();
        for (Property2 p : this.properties) {
            if (!p.isExpanded()) continue;
            expanded.add(p.getProperty().getId());
        }
        this.properties.clear();
        if (this.getModel() != null) {
            PropertyTableModel.collectProperties(this.properties, expanded, 0, this.getModel());
        }
        this.fireTableDataChanged();
    }

    private static void collectProperties(List<Property2> list, Set<String> expanded, int i, PropertyModel model) {
        Collection<String> ids = model.getIds();
        for (String id : ids) {
            CompositeProperty cp;
            Property p = model.getProperty(id);
            Property2 p2 = new Property2(p, i);
            list.add(p2);
            if (expanded.contains(p.getId())) {
                p2.setExpanded(true);
            }
            if (!p2.isExpanded() || !(p instanceof CompositeProperty) || (cp = (CompositeProperty)p).getChildCount() <= 0) continue;
            PropertyTableModel.collectProperties(list, expanded, i + 1, cp.getPropertyModel());
        }
    }

    @Override
    public int getColumnCount() {
        return 2;
    }

    @Override
    public int getRowCount() {
        return this.properties != null ? this.properties.size() : 0;
    }

    public Property getProperty(int row) {
        return this.properties.get(row).getProperty();
    }

    public boolean isExpanded(int row) {
        return this.properties.get(row).isExpanded();
    }

    public int getIndentation(int row) {
        return this.properties.get(row).getIndentation();
    }

    @Override
    public Object getValueAt(int row, int col) {
        Property2 p2 = this.properties.get(row);
        Property p = p2.getProperty();
        if (col == 0) {
            return p.getName();
        }
        if (col == 1) {
            return p.getValue();
        }
        return null;
    }

    public PropertyModel getModel() {
        return this.model;
    }

    public TableCellEditor getEditor(String id) {
        return this.model.getEditor(id);
    }

    public TableCellRenderer getRenderer(String id) {
        return this.model.getRenderer(id);
    }

    public void setModel(PropertyModel m) {
        if (this.model != m) {
            this.model = m;
            this.onModelChanged();
        }
    }

    public void setExpanded(int row, boolean expanded) {
        Property2 p2 = this.properties.get(row);
        if (p2.isExpanded() != expanded) {
            p2.setExpanded(expanded);
            this.onModelChanged();
        }
    }

    @Override
    public void setValueAt(Object value, int row, int col) {
        Property p = this.getProperty(row);
        p.setValue(value);
        this.fireTableRowsUpdated(row, row);
    }

    protected static class Property2 {
        private Property property;
        private int indentation;
        private boolean isExpanded;

        public Property2(Property p, int indentation) {
            this.property = p;
            this.indentation = indentation;
        }

        public Property getProperty() {
            return this.property;
        }

        public int getIndentation() {
            return this.indentation;
        }

        public boolean isExpanded() {
            return this.isExpanded;
        }

        public void setExpanded(boolean isExpanded) {
            this.isExpanded = isExpanded;
        }
    }
}

