/*
 * Decompiled with CFR 0.152.
 */
package timon.common.components.property;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import timon.common.components.property.CompositeProperty;
import timon.common.components.property.Property;
import timon.common.components.property.PropertyTableModel;
import timon.common.components.property.editor.BooleanPropertyEditor;
import timon.common.components.property.editor.BooleanPropertyRenderer;
import timon.common.components.property.editor.ColorPropertyEditor;
import timon.common.components.property.editor.DefaultPropertyRenderer;
import timon.common.components.property.editor.FloatPropertyEditor;
import timon.common.components.property.editor.IntPropertyEditor;
import timon.common.components.property.editor.StringPropertyEditor;
import timon.common.internal.Icons;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertyTable
extends JTable {
    private static final String PREFIX = "components.property.PropertyTable.";
    private PropertyTableModel model;
    private TableCellRenderer labelRenderer;
    private TableCellRenderer defaultPropertyRenderer;
    private Map<Class<?>, TableCellRenderer> rendererMap;
    private Map<Class<?>, TableCellEditor> editorMap;
    private LabelIcon labelIcon;
    private Icon collapsedIcon;
    private Icon expandedIcon;

    public PropertyTable(PropertyTableModel m) {
        super(m);
        this.model = m;
        this.labelRenderer = this.createLabelRenderer();
        this.defaultPropertyRenderer = this.createDefaultPropertyRenderer();
        this.labelIcon = new LabelIcon();
        this.collapsedIcon = Icons.get("components.property.PropertyTable.collapsedIcon");
        this.expandedIcon = Icons.get("components.property.PropertyTable.expandedIcon");
        this.rendererMap = new HashMap();
        this.editorMap = new HashMap();
        this.createCellRenderers(this.rendererMap);
        this.createCellEditors(this.editorMap);
        this.setTableHeader(null);
        this.setSelectionMode(0);
        this.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent event) {
                Property p;
                int row = PropertyTable.this.rowAtPoint(event.getPoint());
                int col = PropertyTable.this.columnAtPoint(event.getPoint());
                if (row >= 0 && row < PropertyTable.this.model.getRowCount() && col == 0 && (p = PropertyTable.this.model.getProperty(row)) instanceof CompositeProperty && ((CompositeProperty)p).getChildCount() > 0) {
                    PropertyTable.this.stopCellEditing();
                    PropertyTable.this.model.setExpanded(row, !PropertyTable.this.model.isExpanded(row));
                    PropertyTable.this.setRowSelectionInterval(row, row);
                }
            }
        });
    }

    protected TableCellRenderer createLabelRenderer() {
        DefaultTableCellRenderer renderer = new DefaultTableCellRenderer(){

            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                Component component = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                JLabel label = component instanceof JLabel ? (JLabel)component : null;
                Property p = PropertyTable.this.model.getProperty(row);
                boolean expanded = PropertyTable.this.model.isExpanded(row);
                if (label != null) {
                    label.setText(label.getText());
                    label.setIcon(PropertyTable.this.labelIcon);
                    int indent = PropertyTable.this.model.getIndentation(row);
                    if (p instanceof CompositeProperty && ((CompositeProperty)p).getChildCount() > 0) {
                        label.setBackground(new Color(240, 240, 240));
                        if (column == 0) {
                            label.setIconTextGap(0);
                            PropertyTable.this.labelIcon.setIcon(expanded ? PropertyTable.this.getExpandedIcon() : PropertyTable.this.getCollapsedIcon(), indent);
                        } else {
                            PropertyTable.this.labelIcon.setIcon(null, 0);
                        }
                    } else {
                        label.setBackground(new Color(220, 220, 220));
                        label.setIconTextGap(1 + PropertyTable.this.getCollapsedIcon().getIconWidth());
                        PropertyTable.this.labelIcon.setIcon(null, indent);
                    }
                }
                return component;
            }
        };
        return renderer;
    }

    protected TableCellRenderer createDefaultPropertyRenderer() {
        return new DefaultPropertyRenderer();
    }

    protected void createCellRenderers(Map<Class<?>, TableCellRenderer> rendererMap) {
        BooleanPropertyRenderer booleanRenderer = new BooleanPropertyRenderer();
        rendererMap.put(Boolean.class, booleanRenderer);
        ColorPropertyEditor colorRenderer = new ColorPropertyEditor();
        rendererMap.put(Color.class, colorRenderer);
    }

    protected void createCellEditors(Map<Class<?>, TableCellEditor> editorMap) {
        StringPropertyEditor stringEditor = new StringPropertyEditor(new JTextField());
        editorMap.put(String.class, stringEditor);
        IntPropertyEditor intEditor = new IntPropertyEditor(new JTextField());
        editorMap.put(Integer.class, intEditor);
        FloatPropertyEditor floatEditor = new FloatPropertyEditor(new JTextField());
        editorMap.put(Float.class, floatEditor);
        BooleanPropertyEditor booleanEditor = new BooleanPropertyEditor(new JCheckBox());
        editorMap.put(Boolean.class, booleanEditor);
        ColorPropertyEditor colorEditor = new ColorPropertyEditor();
        editorMap.put(Color.class, colorEditor);
    }

    public void stopCellEditing() {
        TableCellEditor editor = this.getCellEditor();
        if (editor != null) {
            editor.stopCellEditing();
        }
    }

    @Override
    public TableCellRenderer getCellRenderer(int row, int col) {
        if (col == 0) {
            return this.labelRenderer;
        }
        Property p = this.model.getProperty(row);
        if (p instanceof CompositeProperty && ((CompositeProperty)p).getChildCount() > 0) {
            return this.labelRenderer;
        }
        TableCellRenderer renderer = this.model.getRenderer(p.getId());
        if (renderer != null) {
            return renderer;
        }
        Class<?> c = p.getBaseClass();
        while (c != null && !c.equals(Object.class)) {
            renderer = this.rendererMap.get(c);
            if (renderer != null) {
                return renderer;
            }
            c = c.getSuperclass();
        }
        return this.defaultPropertyRenderer;
    }

    @Override
    public TableCellEditor getCellEditor(int row, int column) {
        if (column == 0) {
            return null;
        }
        Property p = this.model.getProperty(row);
        TableCellEditor editor = this.model.getEditor(p.getId());
        if (editor != null) {
            return editor;
        }
        Class<?> c = p.getBaseClass();
        while (c != null && !c.equals(Object.class)) {
            editor = this.editorMap.get(c);
            if (editor != null) {
                return editor;
            }
            c = c.getSuperclass();
        }
        return null;
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        if (column == 0) {
            return false;
        }
        Property p = this.model.getProperty(row);
        return p.isEditable();
    }

    public Icon getExpandedIcon() {
        return this.expandedIcon;
    }

    public Icon getCollapsedIcon() {
        return this.collapsedIcon;
    }

    public void setExpandedIcon(Icon expandedIcon) {
        this.expandedIcon = expandedIcon;
    }

    public void setCollapsedIcon(Icon collapsedIcon) {
        this.collapsedIcon = collapsedIcon;
    }

    public void setRenderer(Class<?> baseClass, TableCellRenderer renderer) {
        this.rendererMap.put(baseClass, renderer);
    }

    private class LabelIcon
    implements Icon {
        private Icon icon;
        private int indent;

        private LabelIcon() {
        }

        public int getIconHeight() {
            return this.icon != null ? this.icon.getIconHeight() : 0;
        }

        public int getIconWidth() {
            return this.indent * 8 + (this.icon != null ? this.icon.getIconWidth() : 0);
        }

        public void setIcon(Icon icon, int indent) {
            this.icon = icon;
            this.indent = indent;
        }

        public void paintIcon(Component c, Graphics g, int x, int y) {
            if (this.icon != null) {
                int w = this.getIconWidth();
                this.icon.paintIcon(c, g, x + w - this.icon.getIconWidth(), y);
            }
        }
    }
}

