/*
 * Decompiled with CFR 0.152.
 */
package timon.common.components.property;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import timon.common.collections.Typed;
import timon.common.components.property.CompositeProperty;
import timon.common.components.property.Property;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertyModel {
    private List<String> ids = new ArrayList<String>();
    private HashMap<String, Property> idMap = new HashMap();
    private HashMap<String, TableCellEditor> editorMap = new HashMap();
    private HashMap<String, TableCellRenderer> rendererMap = new HashMap();
    private List<PropertyChangeListener> propertyListeners = new ArrayList<PropertyChangeListener>();
    private ChildListener childListener = new ChildListener();

    public Property addGroup(String id, String label) {
        return this.addProperty(id, label, null, Object.class);
    }

    public Property addGroup(String groupId, String id, String label) {
        return this.addToGroup(groupId, id, label, null, Object.class);
    }

    public Property addProperty(String prefix, String label, Typed t) {
        return this.addProperty(String.valueOf(prefix) + t.getId(), label, t.getValue(), t.getBaseClass());
    }

    public Property addProperty(String id, Object value, Class<?> baseClass) {
        return this.addProperty(id, id, value, baseClass);
    }

    public Property addProperty(String id, String name, Object value, Class<?> baseClass) {
        CompositeProperty property = new CompositeProperty(id, name, value, baseClass);
        this.idMap.put(id, property);
        this.ids.add(id);
        property.addPropertyListener(this.childListener);
        return property;
    }

    public Property addToGroup(String groupId, String prefix, String label, Typed t) {
        return this.addToGroup(groupId, String.valueOf(prefix) + t.getId(), label, t.getValue(), t.getBaseClass());
    }

    public Property addToGroup(String groupId, String id, Object value, Class<?> baseClass) {
        return this.addToGroup(groupId, id, id, value, baseClass);
    }

    public Property addToGroup(String groupId, String id, String name, Object value, Class<?> baseClass) {
        Property property = this.getProperty(groupId);
        if (!(property instanceof CompositeProperty)) {
            throw new IllegalArgumentException("Invalid group ID: " + groupId);
        }
        CompositeProperty cp = (CompositeProperty)property;
        cp.getPropertyModel().addProperty(id, name, value, baseClass);
        return property;
    }

    public void addPropertyListener(PropertyChangeListener pcl) {
        this.propertyListeners.add(pcl);
    }

    public void removePropertyListener(PropertyChangeListener pcl) {
        this.propertyListeners.remove(pcl);
    }

    public void firePropertyChanged(Object source, String name, Object oldValue, Object newValue) {
        PropertyChangeEvent event = new PropertyChangeEvent(source, name, oldValue, newValue);
        for (PropertyChangeListener pcl : this.propertyListeners) {
            pcl.propertyChange(event);
        }
    }

    public Property getProperty(String id) {
        return this.idMap.get(id);
    }

    public Collection<String> getIds() {
        return this.ids;
    }

    public int getSize() {
        return this.ids.size();
    }

    public PropertyModel getGroup(String groupId) {
        return ((CompositeProperty)this.idMap.get(groupId)).getPropertyModel();
    }

    public TableCellRenderer getRenderer(String id) {
        return this.rendererMap.get(id);
    }

    public TableCellEditor getEditor(String id) {
        return this.editorMap.get(id);
    }

    public void setRenderer(String id, TableCellRenderer renderer) {
        this.rendererMap.put(id, renderer);
    }

    public void setEditor(String id, TableCellEditor editor) {
        this.editorMap.put(id, editor);
    }

    private class ChildListener
    implements PropertyChangeListener {
        private ChildListener() {
        }

        public void propertyChange(PropertyChangeEvent event) {
            PropertyModel.this.firePropertyChanged(event.getSource(), event.getPropertyName(), event.getOldValue(), event.getNewValue());
        }
    }
}

