/*
 * Decompiled with CFR 0.152.
 */
package timon.common.components.property;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Property {
    private String id;
    private String name;
    private boolean isEditable;
    private Object value;
    private Class<?> baseClass;
    private List<PropertyChangeListener> propertyListeners;

    public Property(String id, String name, Class<?> baseClass) {
        this(id, name, null, baseClass);
    }

    public Property(String id, String name, Object value, Class<?> baseClass) {
        this.id = id;
        this.name = name;
        this.value = value;
        this.baseClass = baseClass;
        this.isEditable = true;
        this.propertyListeners = new ArrayList<PropertyChangeListener>(2);
    }

    public void addPropertyListener(PropertyChangeListener pcl) {
        this.propertyListeners.add(pcl);
    }

    public void removePropertyListener(PropertyChangeListener pcl) {
        this.propertyListeners.remove(pcl);
    }

    public void firePropertyChanged(Object source, String id, Object oldValue, Object newValue) {
        PropertyChangeEvent event = new PropertyChangeEvent(source, id, oldValue, newValue);
        for (PropertyChangeListener pcl : this.propertyListeners) {
            pcl.propertyChange(event);
        }
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public Object getValue() {
        return this.value;
    }

    public boolean isEditable() {
        return this.isEditable;
    }

    public Class<?> getBaseClass() {
        return this.baseClass;
    }

    public void setValue(Object v) {
        if (this.value != v) {
            Object oldValue = this.value;
            this.value = v;
            this.firePropertyChanged(this, this.id, oldValue, this.value);
        }
    }

    public void setEditable(boolean isEditable) {
        this.isEditable = isEditable;
    }
}

