/*
 * Decompiled with CFR 0.152.
 */
package timon.common.components.progress;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import timon.common.Log;
import timon.common.components.progress.ProgressListener;
import timon.common.components.progress.ProgressRunnable;

public class ProgressDialog {
    private JPanel panel;
    private JLabel messageLabel = new JLabel("Initializing...");
    private JProgressBar progressBar = new JProgressBar();

    public ProgressDialog() {
        this.panel = new JPanel(new BorderLayout(5, 5));
        this.panel.setBorder(new EmptyBorder(10, 10, 10, 10));
        this.panel.add((Component)this.messageLabel, "Center");
        this.panel.add((Component)this.progressBar, "South");
    }

    public void showDialog(final ProgressRunnable task, final ProgressListener pl) {
        final JDialog dialog = new JDialog();
        dialog.setResizable(false);
        dialog.setDefaultCloseOperation(0);
        dialog.setAlwaysOnTop(true);
        this.panel.setPreferredSize(new Dimension(400, 60));
        dialog.add(this.panel);
        dialog.pack();
        dialog.setLocationRelativeTo(null);
        dialog.setVisible(true);
        final ProgressListener progressListener = new ProgressListener(){

            public void onProgress(final int value, final int max, final String message) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        ProgressDialog.this.progressBar.setMaximum(max);
                        ProgressDialog.this.progressBar.setValue(value);
                        ProgressDialog.this.messageLabel.setText(message);
                        if (pl != null) {
                            pl.onProgress(value, max, message);
                        }
                    }
                });
            }

            public void onFinished(final String message) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        ProgressDialog.this.progressBar.setValue(ProgressDialog.this.progressBar.getMaximum());
                        if (pl != null) {
                            pl.onFinished(message);
                        }
                    }
                });
            }
        };
        Thread t = new Thread(new Runnable(){

            public void run() {
                try {
                    task.run(progressListener);
                }
                catch (Exception e) {
                    Log.showError(e);
                }
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        dialog.dispose();
                    }
                });
            }
        });
        t.start();
    }
}

