/*
 * Decompiled with CFR 0.152.
 */
package timon.common.components.multibrowser;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ComboBoxEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToggleButton;
import javax.swing.JViewport;
import javax.swing.border.EmptyBorder;
import timon.common.collections.BasicTreeNode;
import timon.common.components.BigPopupCombo;
import timon.common.components.DirectTextField;
import timon.common.components.StringSortedListModel;
import timon.common.components.TextChangeListener;
import timon.common.components.multibrowser.MVBrowser;
import timon.common.components.multibrowser.MVFolder;
import timon.common.components.multibrowser.MVIconBrowser;
import timon.common.components.multibrowser.MVListBrowser;
import timon.common.internal.Icons;
import timon.common.internal.Text;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class MultiViewBrowser
extends JPanel {
    private static final String PREFIX = "components.multibrowser.MultiViewBrowser.";
    private String filter = "";
    private int disableInputListeners;
    private Object model;
    private LinkedList<ActionListener> actionListeners = new LinkedList();
    private List<MVBrowser> views = new LinkedList<MVBrowser>();
    private MVBrowser activeView;
    private List<ViewButton> viewButtons = new LinkedList<ViewButton>();
    private JScrollPane scrollPane;
    private Action deleteAction;
    private Set<Class<?>> folderTypes = new HashSet();
    private JComponent topPanel;
    private JComboBox filterField;
    private JPanel viewButtonPanel;

    public MultiViewBrowser(boolean doUpdate) {
        this.addFolderType(MVFolder.class);
        this.deleteAction = new AbstractAction(){

            public boolean isEnabled() {
                return MultiViewBrowser.this.getSelectedValue() != null;
            }

            public void actionPerformed(ActionEvent event) {
                MultiViewBrowser.this.delete(MultiViewBrowser.this.getSelectedValue());
            }
        };
        this.topPanel = this.createTopPanel();
        this.scrollPane = new JScrollPane();
        this.scrollPane.setVerticalScrollBarPolicy(22);
        this.setLayout(new BorderLayout());
        this.add((Component)this.topPanel, "North");
        this.add((Component)this.scrollPane, "Center");
        this.createViews();
        if (doUpdate) {
            this.update();
        }
    }

    protected void createViews() {
        this.addView(new MVListBrowser(this));
        this.addView(new MVIconBrowser(this));
    }

    protected JComponent createTopPanel() {
        JLabel filterLabel = new JLabel(Text.get("components.multibrowser.MultiViewBrowser.filter"));
        this.filterField = new BigPopupCombo(200);
        this.filterField.setPreferredSize(new Dimension(70, 20));
        this.filterField.setEditable(true);
        final DirectTextField editorComponent = new DirectTextField();
        final ActionListener comboListener = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (MultiViewBrowser.this.disableInputListeners == 0) {
                    if (MultiViewBrowser.this.filterField.isEditable()) {
                        MultiViewBrowser.this.setFilter(editorComponent.getText());
                    } else {
                        Object object = MultiViewBrowser.this.filterField.getSelectedItem();
                        MultiViewBrowser.this.setFilter(object != null ? object.toString() : "");
                    }
                }
            }
        };
        editorComponent.setBorder(null);
        editorComponent.addTextChangeListener(new TextChangeListener(){

            public void textChanged(Object source, String newText) {
                int pos = editorComponent.getCaretPosition();
                comboListener.actionPerformed(new ActionEvent(source, 0, newText));
                editorComponent.setCaretPosition(Math.min(pos, editorComponent.getText().length()));
            }
        });
        this.filterField.setEditor(new ComboBoxEditor(){

            public void addActionListener(ActionListener l) {
            }

            public void removeActionListener(ActionListener l) {
            }

            public Component getEditorComponent() {
                return editorComponent;
            }

            public void selectAll() {
                editorComponent.selectAll();
            }

            public Object getItem() {
                return editorComponent.getText();
            }

            public void setItem(Object anObject) {
                editorComponent.setUndoEnabled(false);
                editorComponent.setText(anObject == null ? "" : anObject.toString());
                editorComponent.setUndoEnabled(true);
            }
        });
        this.filterField.addActionListener(comboListener);
        this.viewButtonPanel = new JPanel(new FlowLayout(0, 2, 0));
        this.viewButtonPanel.setBorder(new EmptyBorder(0, 0, 0, 0));
        JPanel toolBar = new JPanel();
        toolBar.setBorder(new EmptyBorder(5, 5, 5, 5));
        toolBar.setLayout(new BoxLayout(toolBar, 0));
        toolBar.add(filterLabel);
        toolBar.add(Box.createHorizontalStrut(5));
        toolBar.add(Box.createHorizontalGlue());
        toolBar.add(this.filterField);
        toolBar.add(Box.createHorizontalStrut(5));
        toolBar.add(this.viewButtonPanel);
        return toolBar;
    }

    public void addFolderType(Class<?> c) {
        this.folderTypes.add(c);
    }

    public void removeFolderType(Class<?> c) {
        this.folderTypes.remove(c);
    }

    public void update() {
        if (this.disableInputListeners > 0) {
            return;
        }
        ++this.disableInputListeners;
        if (this.scrollPane.getViewport() != null) {
            this.scrollPane.getViewport().setView(null);
            this.scrollPane.getViewport().removeAll();
        } else {
            this.scrollPane.setViewport(new JViewport());
        }
        BasicTreeNode<?> data = this.sortData(this.createFilteredData(this.filter));
        Vector<String> filters = this.createFilterComboSelections();
        int n = 0;
        while (n < filters.size()) {
            String s = filters.get(n);
            if (s != null) {
                s = s.toLowerCase();
            }
            filters.set(n, s);
            ++n;
        }
        this.filterField.setModel(new DefaultComboBoxModel<String>(filters));
        this.filterField.setSelectedItem(this.filter);
        this.activeView.setRootNode(data);
        this.scrollPane.getViewport().setView(this.activeView.getComponent());
        this.validate();
        --this.disableInputListeners;
        if (data.contains(this.model)) {
            this.setSelectedValue(this.model, true, true);
        } else {
            this.setSelectedValue(null, true, true);
        }
    }

    protected BasicTreeNode<?> sortData(BasicTreeNode<?> node) {
        node.sortChildren(new Comparator<Object>(){
            Comparator<String> comp = StringSortedListModel.createComparator();

            @Override
            public int compare(Object o1, Object o2) {
                return this.comp.compare(MultiViewBrowser.this.getLabelFor(o1), MultiViewBrowser.this.getLabelFor(o2));
            }
        });
        return node;
    }

    protected void onItemSelected(Object item) {
        if (this.model != item) {
            this.model = item;
            this.fireSelectionChanged();
        }
    }

    protected void onItemDoubleClicked(Object item) {
    }

    protected void onSelectedPathChanged(List<Object> path) {
    }

    protected abstract BasicTreeNode<?> createFilteredData(String var1);

    protected abstract Vector<String> createFilterComboSelections();

    protected abstract Image getImageFor(Object var1);

    public abstract void delete(Object var1);

    public void addView(MVBrowser view) {
        this.views.add(view);
        this.updateViews();
    }

    public void removeView(MVBrowser view) {
        this.views.remove(view);
        this.updateViews();
    }

    public void updateViews() {
        if (this.activeView == null && this.views.size() > 0) {
            this.activeView = this.views.get(0);
        }
        this.viewButtons.clear();
        this.viewButtonPanel.removeAll();
        for (MVBrowser view : this.views) {
            ViewButton button = new ViewButton(view);
            if (view == this.activeView) {
                button.setSelected(true);
            }
            this.viewButtons.add(button);
            this.viewButtonPanel.add(button);
        }
        if (this.viewButtons.size() == 1) {
            this.viewButtons.get(0).setEnabled(false);
        }
        this.viewButtonPanel.setPreferredSize(new Dimension(this.views.size() * 20, 25));
        this.validate();
    }

    public void addActionListener(ActionListener al) {
        this.actionListeners.add(al);
    }

    public void removeActionListener(ActionListener al) {
        this.actionListeners.remove(al);
    }

    public void fireSelectionChanged() {
        ActionListener[] al = new ActionListener[this.actionListeners.size()];
        this.actionListeners.toArray(al);
        ActionEvent event = new ActionEvent(this, 0, "Selected");
        ActionListener[] actionListenerArray = al;
        int n = al.length;
        int n2 = 0;
        while (n2 < n) {
            ActionListener a = actionListenerArray[n2];
            a.actionPerformed(event);
            ++n2;
        }
    }

    protected String getLabelFor(Object object) {
        return String.valueOf(object);
    }

    public List<Object> getSelectedPath() {
        return this.activeView != null ? this.activeView.getSelectedPath() : new LinkedList();
    }

    public Object getSelectedValue() {
        return this.model;
    }

    public String getFilter() {
        return this.filter;
    }

    public JScrollPane getScrollPane() {
        return this.scrollPane;
    }

    public JViewport getViewPort() {
        return this.scrollPane.getViewport();
    }

    public Action getDeleteAction() {
        return this.deleteAction;
    }

    public MVBrowser getActiveView() {
        return this.activeView;
    }

    public List<MVBrowser> getViews() {
        return this.views;
    }

    public boolean isFolderType(Class<?> c) {
        return this.folderTypes.contains(c);
    }

    protected Image getFolderImage() {
        return Icons.get("components.multibrowser.MultiViewBrowser.folderImage").getImage();
    }

    protected Image getFileImage() {
        return Icons.get("components.multibrowser.MultiViewBrowser.fileImage").getImage();
    }

    public void setFilterEnabled(boolean b) {
        this.filterField.setEnabled(b);
    }

    public void setFilterEditable(boolean b) {
        this.filterField.setEditable(b);
    }

    public void setActiveView(MVBrowser view) {
        if (view == this.activeView) {
            return;
        }
        List<Object> selectedPath = this.activeView.getSelectedPath();
        Object selected = this.model;
        for (ViewButton button : this.viewButtons) {
            button.setSelected(button.getView() == view);
        }
        this.activeView = view;
        this.update();
        ++this.disableInputListeners;
        this.activeView.setSelectedPath(selectedPath);
        this.setSelectedValue(selected, true, true);
        this.model = selected;
        this.fireSelectionChanged();
        --this.disableInputListeners;
    }

    public void setFilter(String filter) {
        String filterLC;
        String string = filterLC = filter == null ? "" : filter.toLowerCase();
        if (filterLC.equals(this.filter)) {
            return;
        }
        ++this.disableInputListeners;
        this.filter = filterLC;
        this.filterField.setSelectedItem(filterLC);
        --this.disableInputListeners;
        this.update();
    }

    public void setSelectedValue(Object value, boolean shouldScroll) {
        this.setSelectedValue(value, shouldScroll, false);
    }

    protected void setSelectedValue(Object value, boolean shouldScroll, boolean force) {
        if (!force && this.getSelectedValue() == value) {
            return;
        }
        this.model = value;
        ++this.disableInputListeners;
        this.activeView.setSelectedValue(value, shouldScroll);
        --this.disableInputListeners;
    }

    @Override
    public void setEnabled(boolean e) {
        this.filterField.setEnabled(e);
        for (ViewButton button : this.viewButtons) {
            button.setEnabled(e);
        }
        for (MVBrowser view : this.getViews()) {
            view.getComponent().setEnabled(e);
        }
        super.setEnabled(e);
    }

    public void setTopPanelVisible(boolean v) {
        this.topPanel.setVisible(v);
    }

    private class ViewButton
    extends JToggleButton {
        private MVBrowser view;

        public ViewButton(MVBrowser v) {
            this.view = v;
            this.setIcon(v.getIcon());
            this.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    MultiViewBrowser.this.setActiveView(ViewButton.this.view);
                }
            });
            this.setPreferredSize(new Dimension(23, 23));
        }

        public MVBrowser getView() {
            return this.view;
        }
    }
}

