/*
 * Decompiled with CFR 0.152.
 */
package timon.common.components.multibrowser;

import java.awt.Image;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.border.EmptyBorder;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;
import timon.common.collections.BasicTreeNode;
import timon.common.components.BasicTreeModel;
import timon.common.components.GuiUtil;
import timon.common.components.IconTreeCellRenderer;
import timon.common.components.multibrowser.MVBrowser;
import timon.common.components.multibrowser.MultiViewBrowser;
import timon.common.internal.Icons;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MVListBrowser
extends MVBrowser {
    private static final String PREFIX = "components.multibrowser.MVListBrowser.";
    private JTree tree;

    public MVListBrowser(MultiViewBrowser b) {
        this(b, new JTree());
    }

    public MVListBrowser(MultiViewBrowser b, final JTree tree) {
        super(b);
        this.tree = tree;
        tree.setRootVisible(false);
        tree.setShowsRootHandles(true);
        tree.setExpandsSelectedPaths(true);
        tree.setScrollsOnExpand(true);
        tree.setAutoscrolls(true);
        tree.setBorder(new EmptyBorder(5, 5, 5, 5));
        tree.getSelectionModel().setSelectionMode(1);
        tree.getSelectionModel().addTreeSelectionListener(new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent e) {
                if (MVListBrowser.this.disableInputListeners == 0) {
                    tree.requestFocus();
                    Object value = MVListBrowser.this.getSelectedValue();
                    MVListBrowser.this.setSelectedValue(value, false);
                }
            }
        });
        tree.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent event) {
                if (event.getButton() == 1 && event.getClickCount() >= 2) {
                    MVListBrowser.this.browser.onItemDoubleClicked(MVListBrowser.this.getSelectedValue());
                }
            }
        });
        tree.setCellRenderer(new IconTreeCellRenderer(){

            public Image getImageFor(Object object) {
                Image image = MVListBrowser.this.browser.getImageFor(object);
                if (object != null && MVListBrowser.this.browser.isFolderType(object.getClass())) {
                    image = Icons.get("components.multibrowser.MultiViewBrowser.folderImage").getImage();
                }
                return image;
            }

            public String getLabelFor(Object object) {
                return MVListBrowser.this.browser.getLabelFor(object);
            }
        });
        tree.getInputMap().put(KeyStroke.getKeyStroke(127, 0), "Delete");
        tree.getActionMap().put("Delete", this.browser.getDeleteAction());
    }

    protected Object getSelectedValue() {
        Object node = this.tree.getLastSelectedPathComponent();
        Object select = null;
        if (node instanceof DefaultMutableTreeNode) {
            select = ((DefaultMutableTreeNode)node).getUserObject();
        }
        return select;
    }

    public JTree getTree() {
        return this.tree;
    }

    @Override
    public JComponent getComponent() {
        return this.tree;
    }

    @Override
    public Icon getIcon() {
        return Icons.get("components.multibrowser.MVListBrowser.icon");
    }

    @Override
    public void setRootNode(BasicTreeNode<?> root) {
        ++this.disableInputListeners;
        Object selected = this.getSelectedValue();
        this.tree.setModel(new BasicTreeModel(root));
        int n = 0;
        while (n < this.tree.getRowCount()) {
            this.tree.expandRow(n);
            ++n;
        }
        if (root.contains(selected)) {
            this.setSelectedValue(selected, true);
            --this.disableInputListeners;
        } else {
            --this.disableInputListeners;
            this.setSelectedValue(null, true);
        }
    }

    @Override
    public void setSelectedValue(Object value, boolean scrollToVisible) {
        ++this.disableInputListeners;
        if (value == null) {
            this.tree.getSelectionModel().clearSelection();
            this.fireItemSelected(null);
        } else {
            List<Object> list = GuiUtil.getTreePathForObject(this.tree.getModel(), this.tree.getModel().getRoot(), value);
            if (list != null && list.size() > 1) {
                LinkedList<Object> list2 = new LinkedList<Object>();
                Iterator<Object> i = list.iterator();
                i.next();
                while (i.hasNext()) {
                    list2.add(((DefaultMutableTreeNode)i.next()).getUserObject());
                }
                this.setSelectedPath(list2);
            } else {
                this.setSelectedPath(null);
            }
            if (list != null) {
                this.tree.setSelectionPath(new TreePath(list.toArray()));
                this.tree.scrollPathToVisible(this.tree.getSelectionPath());
                this.fireItemSelected(value);
            } else {
                this.tree.getSelectionModel().clearSelection();
                this.fireItemSelected(null);
            }
        }
        --this.disableInputListeners;
    }
}

