/*
 * Decompiled with CFR 0.152.
 */
package timon.common.components.multibrowser;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import timon.common.collections.BasicTreeNode;
import timon.common.components.multibrowser.ImageButton;
import timon.common.components.multibrowser.MVBrowser;
import timon.common.components.multibrowser.MultiViewBrowser;
import timon.common.internal.Icons;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MVIconBrowser
extends MVBrowser {
    private static final String PREFIX = "components.multibrowser.MVIconBrowser.";
    private int size;
    private int padding = 1;
    private int spacing = 1;
    private ButtonGroup buttonGroup;
    private List<ImageButton> items;
    private BasicTreeNode<?> rootNode;
    private JPanel panel;

    public MVIconBrowser(MultiViewBrowser browser) {
        this(browser, 25);
    }

    public MVIconBrowser(MultiViewBrowser browser, int size) {
        super(browser);
        this.size = size;
        this.panel = this.createPanel();
        this.buttonGroup = new ButtonGroup();
        this.items = new ArrayList<ImageButton>();
        this.setThumbSpacing(this.spacing);
    }

    protected void draw(Graphics2D g, int w, int h) {
        g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        g.setBackground(this.panel.getBackground());
        g.clearRect(0, 0, w, h);
        this.panel.paintComponents(g);
    }

    protected JPanel createPanel() {
        JPanel panel = new JPanel(){

            public void paint(Graphics graphics) {
                MVIconBrowser.this.draw((Graphics2D)graphics, this.getWidth(), this.getHeight());
            }
        };
        FlowLayout layout = new FlowLayout(0){

            public Dimension preferredLayoutSize(Container target) {
                Container parent = target.getParent();
                if (parent != null) {
                    int w = parent.getSize().width;
                    int h = parent.getSize().height;
                    int cw = 0;
                    int ch = 0;
                    Component[] componentArray = target.getComponents();
                    int n = componentArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Component c = componentArray[n2];
                        cw = Math.max(cw, c.getPreferredSize().width);
                        ch = Math.max(ch, c.getPreferredSize().height);
                        c.setSize(cw, ch);
                        ++n2;
                    }
                    int hgap = this.getHgap();
                    int vgap = this.getVgap();
                    if (w >= cw + hgap * 2 && h >= ch + vgap * 2) {
                        int rows;
                        if (cw > 0) {
                            int items = target.getComponentCount();
                            int temp = (w - hgap) / (cw + hgap);
                            rows = items / temp + (items % temp == 0 ? 0 : 1);
                        } else {
                            rows = 0;
                        }
                        int nh = (ch + vgap) * rows + vgap;
                        return new Dimension(w, nh);
                    }
                }
                return super.preferredLayoutSize(target);
            }
        };
        panel.setLayout(layout);
        return panel;
    }

    public void clearItems() {
        this.items.clear();
        this.buttonGroup = new ButtonGroup();
        this.panel.removeAll();
    }

    public AbstractButton createItem(Object value, Image i) {
        ImageButton newItem = this.createItemButton(value, i);
        this.items.add(newItem);
        this.buttonGroup.add(newItem);
        this.panel.add(newItem);
        return newItem;
    }

    protected ImageButton createItemButton(Object value, Image i) {
        return new ImageButton(value, i, this.size, this.padding);
    }

    public void deselect() {
        if (this.buttonGroup.getSelection() != null) {
            this.buttonGroup.getSelection().setSelected(false);
        }
    }

    private void scrollToVisible(JScrollPane scrollPane, AbstractButton item) {
        Rectangle rect = new Rectangle(item.getBounds());
        Rectangle rect2 = this.panel.getVisibleRect();
        if (rect.y < rect2.y) {
            JScrollBar scrollBar = scrollPane.getVerticalScrollBar();
            scrollBar.setValue(rect.y);
            scrollPane.repaint();
        } else if (rect.y + rect.height >= rect2.y + rect2.height) {
            JScrollBar scrollBar = scrollPane.getVerticalScrollBar();
            scrollBar.setValue(rect.y + rect.height - rect2.height);
            scrollPane.repaint();
        }
    }

    @Override
    protected void fireItemDoubleClicked(BasicTreeNode<?> node, Object selection) {
        if (node.getValue() != null && this.browser.isFolderType(node.getValue().getClass())) {
            ++this.disableInputListeners;
            List<Object> path = this.getSelectedPath();
            path.add(node.getValue());
            this.setSelectedPath(path);
            this.setSelectedValue(null, true);
            --this.disableInputListeners;
            this.fireSelectedPathChanged(path);
            this.fireItemSelected(null);
        } else {
            super.fireItemDoubleClicked(node, selection);
        }
    }

    @Override
    protected void fireSelectedPathChanged(List<Object> path) {
        if (this.disableInputListeners == 0) {
            this.setRootNode(this.rootNode);
            this.panel.validate();
            this.panel.getParent().repaint();
            super.fireSelectedPathChanged(path);
        }
    }

    protected boolean calculatePathTo(List<Object> list, BasicTreeNode<?> root, Object value) {
        if (root.getValue() == value) {
            return true;
        }
        for (BasicTreeNode<?> child : root.getChildren()) {
            if (!this.calculatePathTo(list, child, value)) continue;
            list.add(0, root.getValue());
            return true;
        }
        return false;
    }

    protected AbstractButton createItem2(final BasicTreeNode<?> node) {
        final Object value = node != null ? node.getValue() : null;
        Image image = null;
        if (node != null) {
            image = this.browser.getImageFor(value);
            if (image == null) {
                image = node.getChildCount() > 0 ? this.browser.getFolderImage() : this.browser.getFileImage();
            }
        } else {
            image = Icons.get("components.multibrowser.MultiViewBrowser.backImage").getImage();
        }
        final AbstractButton item = this.createItem(value, image);
        item.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent event) {
                if (event.getButton() == 1 && event.getClickCount() >= 2) {
                    if (node != null) {
                        MVIconBrowser.this.fireItemDoubleClicked(node, value);
                    } else {
                        List<Object> path = MVIconBrowser.this.getSelectedPath();
                        if (path.size() > 0) {
                            ++MVIconBrowser.this.disableInputListeners;
                            path.remove(path.size() - 1);
                            MVIconBrowser.this.setSelectedPath(path);
                            MVIconBrowser.this.setSelectedValue(null, true);
                            --MVIconBrowser.this.disableInputListeners;
                            MVIconBrowser.this.fireSelectedPathChanged(path);
                            MVIconBrowser.this.fireItemSelected(null);
                        }
                    }
                }
            }
        });
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                item.requestFocus();
                MVIconBrowser.this.fireItemSelected(value);
            }
        });
        if (node != null) {
            item.addKeyListener(new KeyListener(){

                public void keyPressed(KeyEvent e) {
                    if (e.getKeyCode() == 127) {
                        MVIconBrowser.this.browser.delete(value);
                    }
                }

                public void keyReleased(KeyEvent e) {
                }

                public void keyTyped(KeyEvent e) {
                }
            });
        }
        return item;
    }

    protected Object getSelectedValue() {
        for (ImageButton item : this.items) {
            if (!item.isSelected()) continue;
            return item.getValue();
        }
        return null;
    }

    @Override
    public JComponent getComponent() {
        return this.panel;
    }

    public int getThumbSize() {
        return this.size;
    }

    public int getThumbSpacing() {
        return this.spacing;
    }

    public int getThumbPadding() {
        return this.padding;
    }

    public List<ImageButton> getItems() {
        return this.items;
    }

    @Override
    public Icon getIcon() {
        return Icons.get("components.multibrowser.MVIconBrowser.icon");
    }

    public void setThumbSize(int s) {
        this.size = s;
        for (ImageButton button : this.items) {
            button.setThumbSize(this.size);
            button.setSize(button.getPreferredSize());
        }
        this.panel.validate();
    }

    public void setThumbSpacing(int s) {
        this.spacing = s;
        if (this.panel.getLayout() instanceof FlowLayout) {
            FlowLayout layout = (FlowLayout)this.panel.getLayout();
            layout.setHgap(this.spacing);
            layout.setVgap(this.spacing);
        }
        this.panel.validate();
    }

    @Override
    public void setRootNode(BasicTreeNode<?> root) {
        ++this.disableInputListeners;
        this.rootNode = root;
        List<Object> path = this.getSelectedPath();
        int t = 0;
        while (t < path.size()) {
            boolean found = false;
            for (BasicTreeNode<?> child : root.getChildren()) {
                if (child.getValue() != path.get(t)) continue;
                root = child;
                found = true;
                break;
            }
            if (!found) break;
            ++t;
        }
        while (t < path.size()) {
            path.remove(path.size() - 1);
        }
        this.setSelectedPath(path);
        Object selected = this.getSelectedValue();
        this.clearItems();
        boolean found = false;
        if (path.size() > 0) {
            this.createItem2(null);
        }
        for (BasicTreeNode<?> node : root.getChildren()) {
            this.createItem2(node);
        }
        for (ImageButton item : this.getItems()) {
            if (item.getValue() != selected) continue;
            item.setSelected(true);
            found = true;
        }
        --this.disableInputListeners;
        if (!found) {
            this.fireItemSelected(null);
        }
    }

    @Override
    public void setSelectedValue(Object value, boolean scrollToVisible) {
        if (this.getSelectedValue() == value) {
            return;
        }
        if (value == null) {
            this.deselect();
            this.fireItemSelected(null);
        } else {
            ++this.disableInputListeners;
            LinkedList<Object> list = new LinkedList<Object>();
            if (this.calculatePathTo(list, this.rootNode, value)) {
                list.remove(0);
                this.setSelectedPath(list);
            }
            --this.disableInputListeners;
            this.fireSelectedPathChanged(list);
            for (ImageButton item : this.getItems()) {
                if (value != item.getValue() && (value == null || !value.equals(item.getValue()))) continue;
                item.setSelected(true);
                if (scrollToVisible) {
                    this.scrollToVisible(this.browser.getScrollPane(), item);
                }
                this.fireItemSelected(item.getValue());
                break;
            }
        }
    }
}

