/*
 * Decompiled with CFR 0.152.
 */
package timon.common.components.multibrowser;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import timon.common.collections.BasicTreeNode;
import timon.common.components.multibrowser.MultiViewBrowser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class MVBrowser {
    protected static final String DELETE_ACTION_KEY = "Delete";
    protected MultiViewBrowser browser;
    protected int disableInputListeners;
    private List<Object> selectedPath;

    public MVBrowser(MultiViewBrowser browser) {
        this.browser = browser;
        this.selectedPath = new ArrayList<Object>();
    }

    protected void fireItemSelected(Object selection) {
        this.browser.onItemSelected(selection);
    }

    protected void fireItemDoubleClicked(BasicTreeNode<?> node, Object selection) {
        this.browser.onItemDoubleClicked(selection);
    }

    protected void fireSelectedPathChanged(List<Object> path) {
        this.browser.onSelectedPathChanged(path);
    }

    public abstract Icon getIcon();

    public abstract JComponent getComponent();

    protected List<Object> getSelectedPath() {
        return new LinkedList<Object>(this.selectedPath);
    }

    public abstract void setRootNode(BasicTreeNode<?> var1);

    public abstract void setSelectedValue(Object var1, boolean var2);

    protected void setSelectedPath(List<Object> path) {
        if (!this.selectedPath.equals(path)) {
            if (path == null) {
                path = new LinkedList<Object>();
            }
            this.selectedPath = path;
            this.fireSelectedPathChanged(path);
        }
    }
}

