/*
 * Decompiled with CFR 0.152.
 */
package timon.common.components.multibrowser;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Shape;
import javax.swing.JRadioButton;
import timon.common.GraphicsUtil;
import timon.common.components.GuiUtil;

public class ImageButton
extends JRadioButton {
    private Object value;
    private Image image;
    private int iw;
    private int ih;
    private int size;
    private int padding;

    public ImageButton(Object value, Image image, int size, int padding) {
        this.value = value;
        this.image = image;
        this.size = size;
        this.padding = padding;
        this.setOpaque(false);
        this.setThumbSize(size);
        this.setSize(this.getPreferredSize());
    }

    public Object getValue() {
        return this.value;
    }

    public Image getImage() {
        return this.image;
    }

    public int getThumbSize() {
        return this.size;
    }

    public Dimension getPreferredSize() {
        return new Dimension(this.size + this.padding * 2, this.size + this.padding * 2);
    }

    public void setThumbSize(int s) {
        this.size = s;
        if (this.image != null) {
            Dimension d = GraphicsUtil.getProportionalScale(this.image.getWidth(null), this.image.getHeight(null), this.size - 4, this.size - 4);
            this.iw = d.width;
            this.ih = d.height;
        } else {
            this.ih = 0;
            this.iw = 0;
        }
    }

    protected void paintComponent(Graphics graphics) {
        Graphics2D g = (Graphics2D)graphics;
        int w = this.getWidth();
        int h = this.getHeight();
        int ix = this.padding + (this.getThumbSize() - this.iw) / 2;
        int iy = this.padding + (this.getThumbSize() - this.ih) / 2;
        g.setColor(new Color(240, 240, 240));
        g.fillRect(0, 0, w, h);
        if (this.isSelected()) {
            GuiUtil.drawSelectionRect(g, 0, 0, w, h);
        }
        Shape s = g.getClip();
        g.clipRect(this.padding, this.padding, this.getThumbSize(), this.getThumbSize());
        g.drawImage(this.image, ix, iy, this.iw, this.ih, this);
        g.setClip(s);
    }
}

