/*
 * Decompiled with CFR 0.152.
 */
package timon.common.components.multibrowser;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.Map;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import timon.common.components.EditableList;
import timon.common.components.multibrowser.MultiViewBrowser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class EditableMultiViewBrowser
extends EditableList<Object> {
    protected MultiViewBrowser list;
    private Map<ListSelectionListener, ActionListener> mappedListeners = new HashMap<ListSelectionListener, ActionListener>();

    public EditableMultiViewBrowser(MultiViewBrowser list, boolean vertical) {
        super(vertical);
        this.setList(list);
    }

    @Override
    protected void addComponents(boolean vertical) {
        this.setLayout(new BorderLayout());
        this.add((Component)this.getList(), "Center");
        this.getList().add((Component)this.buttonPanel, vertical ? "East" : "South");
    }

    @Override
    public void delete() {
        if (this.getSelectedValue() != null) {
            this.getList().delete(this.getSelectedValue());
        }
    }

    @Override
    public void moveItem(int direction) {
    }

    @Override
    public void addListSelectionListener(final ListSelectionListener lsl) {
        ActionListener al = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                lsl.valueChanged(null);
            }
        };
        this.getList().addActionListener(al);
        if (this.mappedListeners != null) {
            this.mappedListeners.put(lsl, al);
        }
    }

    @Override
    public void removeListSelectionListener(ListSelectionListener lsl) {
        this.getList().removeActionListener(this.mappedListeners.remove(lsl));
    }

    @Override
    public Object getSelectedValue() {
        return this.getList().getSelectedValue();
    }

    @Override
    protected MultiViewBrowser getList() {
        return this.list;
    }

    @Override
    public void setSelectedValue(Object value, boolean shouldScroll) {
        this.list.setSelectedValue(value, shouldScroll);
    }

    @Override
    public void setList(Object list) {
        this.list = (MultiViewBrowser)list;
        super.setList(list);
        this.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                EditableMultiViewBrowser.this.updateButtons();
            }
        });
    }
}

