/*
 * Decompiled with CFR 0.152.
 */
package timon.common.components.graph;

import java.util.List;
import timon.common.collections.Tuple2;
import timon.common.components.graph.GraphModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScrollingGraphModel<Y>
extends GraphModel<Double, Y> {
    public ScrollingGraphModel(int sets, double min, double max, Y min2, Y max2) {
        super(sets, min, max, min2, max2);
    }

    public ScrollingGraphModel(int sets, Tuple2<Double, Double> horizontalRange, Tuple2<Y, Y> verticalRange) {
        super(sets, horizontalRange, verticalRange);
    }

    @Override
    public void addValue(int setIndex, Double x, Y y) {
        List values = this.getValues(setIndex);
        if (values.size() > 0 && (Double)values.get((int)(values.size() - 1)).x > x) {
            throw new IllegalArgumentException("You have to add the values in order! (" + values.get((int)(values.size() - 1)).x + " > " + x);
        }
        super.addValue(setIndex, x, y);
    }

    public void setMaxX(double maxX) {
        double span = Math.abs((Double)this.getHorizontalRange().y - (Double)this.getHorizontalRange().x);
        this.getHorizontalRange().x = maxX - span;
        this.getHorizontalRange().y = maxX;
        this.onChange();
    }
}

