/*
 * Decompiled with CFR 0.152.
 */
package timon.common.components.graph;

import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.image.MemoryImageSource;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import timon.common.collections.Tuple2;
import timon.common.components.graph.Graph;
import timon.common.components.graph.GraphModel;
import timon.common.components.graph.ScrollingGraphModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScrollingGraph
extends Graph<Double, Double> {
    private Image image;
    private MemoryImageSource imageModel;
    private int[] rgb;

    public ScrollingGraph(String title, ScrollingGraphModel<Double> model) {
        super(title, model);
    }

    @Override
    protected void createBuffer(int w, int h) {
        super.createBuffer(w, h);
        if (this.image != null) {
            this.image.flush();
        }
        Rectangle r = this.getForegroundRect();
        this.rgb = new int[r.width * r.height];
        this.imageModel = new MemoryImageSource(r.width, r.height, this.rgb, 0, r.width);
        this.imageModel.setAnimated(true);
        this.image = Toolkit.getDefaultToolkit().createImage(this.imageModel);
    }

    @Override
    protected void drawForeground(Graphics2D graphics, int w, int h) {
        Rectangle r = this.getForegroundRect();
        if (this.image == null || this.rgb.length < r.width * r.height) {
            return;
        }
        GraphModel model = this.getModel();
        Tuple2 rangeX = model.getHorizontalRange();
        Arrays.fill(this.rgb, 0);
        int setIndex = 0;
        while (setIndex < model.getValueSets()) {
            List list = model.getValues(setIndex);
            Iterator it = list.iterator();
            if (it.hasNext()) {
                Tuple2 lastPoint = null;
                Tuple2 point = it.next();
                int color = this.getModel().getColor(setIndex).getRGB();
                boolean filled = this.getModel().isFilled(setIndex);
                while (it.hasNext()) {
                    lastPoint = point;
                    point = it.next();
                    if ((Double)point.x > (Double)rangeX.y) break;
                    this.drawSection(color, filled, (Double)lastPoint.x, (Double)lastPoint.y, (Double)point.x, (Double)point.y);
                }
            }
            ++setIndex;
        }
        this.imageModel.newPixels();
        graphics.drawImage(this.image, 0, 0, w, h, this);
    }

    protected void drawSection(int color, boolean filled, double x0, double y0, double x1, double y1) {
        Rectangle r = this.getForegroundRect();
        Tuple2 rangeX = this.getModel().getHorizontalRange();
        Tuple2 rangeY = this.getModel().getVerticalRange();
        int minX = Math.max(0, (int)Math.ceil((double)r.width * (x0 - (Double)rangeX.x) / ((Double)rangeX.y - (Double)rangeX.x)));
        int maxX = Math.min(r.width - 1, (int)Math.floor((double)r.width * (x1 - (Double)rangeX.x) / ((Double)rangeX.y - (Double)rangeX.x)));
        int x = minX;
        while (x <= maxX) {
            double px = (Double)rangeX.x + (double)x / (double)r.width * ((Double)rangeX.y - (Double)rangeX.x);
            double py = this.interpolateY(x0, y0, x1, y1, px);
            int y = r.height - (int)Math.round((double)r.height * (py - (Double)rangeY.x) / ((Double)rangeY.y - (Double)rangeY.x));
            y = Math.max(0, Math.min(r.height, y));
            int offset = x + y * r.width;
            int bmax = filled ? r.height : Math.min(r.height, y + 2);
            int b = y;
            while (b < bmax) {
                this.rgb[offset] = color;
                offset += r.width;
                ++b;
            }
            ++x;
        }
    }

    protected double interpolateY(double x0, double y0, double x1, double y1, double x) {
        double frac = (x - x0) / (x1 - x0);
        return y0 + frac * (y1 - y0);
    }

    public void reset() {
        if (this.rgb != null) {
            Arrays.fill(this.rgb, 0);
        }
    }

    public ScrollingGraphModel<Double> getModel() {
        return (ScrollingGraphModel)super.getModel();
    }
}

