/*
 * Decompiled with CFR 0.152.
 */
package timon.common.components.graph;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import timon.common.collections.Tuple2;
import timon.common.components.graph.Graph;
import timon.common.components.graph.GraphModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LineGraph
extends Graph<Double, Double> {
    private boolean drawAreaUnder = true;

    public LineGraph(String title, GraphModel<Double, Double> model) {
        super(title, model);
    }

    @Override
    protected void drawForeground(Graphics2D g, int w, int h) {
        Stroke oldStroke = g.getStroke();
        Shape oldClip = g.getClip();
        AffineTransform oldTransform = g.getTransform();
        g.clipRect(1, 1, w - 2, h - 2);
        GraphModel model = this.getModel();
        Tuple2 rangeX = model.getHorizontalRange();
        Tuple2 rangeY = model.getVerticalRange();
        double ty = (double)h * (Double)rangeY.x / Math.abs((Double)rangeY.y - (Double)rangeY.x);
        g.translate((double)(-w) * (Double)rangeX.x / Math.abs((Double)rangeX.y - (Double)rangeX.x), ty);
        g.setStroke(new BasicStroke(3.0f));
        int setIndex = 0;
        while (setIndex < model.getValueSets()) {
            ArrayList list = new ArrayList(model.getValues(setIndex));
            Collections.sort(list, new Comparator<Tuple2<Double, Double>>(){

                @Override
                public int compare(Tuple2<Double, Double> t1, Tuple2<Double, Double> t2) {
                    return ((Double)t1.x).compareTo((Double)t2.x);
                }
            });
            int[] px = new int[list.size() + 2];
            int[] py = new int[list.size() + 2];
            int t = 0;
            for (Tuple2 tuple2 : list) {
                px[t] = (int)Math.round((double)w * (Double)tuple2.x / Math.abs((Double)rangeX.y - (Double)rangeX.x));
                py[t] = (int)Math.round((double)h * (1.0 - (Double)tuple2.y / Math.abs((Double)rangeY.y - (Double)rangeY.x)));
                ++t;
            }
            if (t > 0) {
                Color color = model.getColor(setIndex);
                if (this.drawAreaUnder) {
                    px[t] = px[t - 1];
                    py[t] = (int)((double)h - ty);
                    px[++t] = px[0];
                    py[t] = (int)((double)h - ty);
                    ++t;
                    g.setColor(new Color(Math.min(255, color.getRed() + 100), Math.min(255, color.getGreen() + 100), Math.min(255, color.getBlue() + 100)));
                    g.fillPolygon(px, py, list.size() + 2);
                }
                g.setColor(color);
                g.drawPolyline(px, py, list.size());
            }
            ++setIndex;
        }
        g.setTransform(oldTransform);
        g.setClip(oldClip);
        g.setStroke(oldStroke);
    }
}

