/*
 * Decompiled with CFR 0.152.
 */
package timon.common.components.graph;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import timon.common.collections.Tuple2;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GraphModel<X extends Comparable<X>, Y> {
    private List<ChangeListener> changeListeners;
    private List<List<Tuple2<X, Y>>> values;
    private List<Color> colors;
    private List<Boolean> filled;
    private boolean disableChangeListeners;
    private Tuple2<X, X> horizontalRange;
    private Tuple2<Y, Y> verticalRange;

    public GraphModel(int sets, X hMin, X hMax, Y vMin, Y vMax) {
        this(sets, new Tuple2<X, X>(hMin, hMax), new Tuple2<Y, Y>(vMin, vMax));
    }

    public GraphModel(int sets, Tuple2<X, X> horizontalRange, Tuple2<Y, Y> verticalRange) {
        this.horizontalRange = horizontalRange;
        this.verticalRange = verticalRange;
        this.changeListeners = new LinkedList<ChangeListener>();
        this.values = new ArrayList<List<Tuple2<X, Y>>>();
        this.colors = new ArrayList<Color>();
        this.filled = new ArrayList<Boolean>();
        int n = 0;
        while (n < sets) {
            this.values.add(new LinkedList());
            this.colors.add(new Color(255, 0, 0));
            this.filled.add(Boolean.TRUE);
            ++n;
        }
    }

    public void addChangeListener(ChangeListener cl) {
        this.changeListeners.add(cl);
    }

    public void removeChangeListener(ChangeListener cl) {
        this.changeListeners.remove(cl);
    }

    public void onChange() {
        if (!this.disableChangeListeners) {
            ChangeListener[] ls;
            ChangeEvent event = new ChangeEvent(this);
            ChangeListener[] changeListenerArray = ls = this.changeListeners.toArray(new ChangeListener[0]);
            int n = ls.length;
            int n2 = 0;
            while (n2 < n) {
                ChangeListener l = changeListenerArray[n2];
                l.stateChanged(event);
                ++n2;
            }
        }
    }

    public void addValue(int setIndex, X x, Y y) {
        this.values.get(setIndex).add(new Tuple2<X, Y>(x, y));
        this.onChange();
    }

    public void removeValue(int setIndex, X x) {
        this.removeValue(setIndex, x, 0);
    }

    public void removeValuesBefore(int setIndex, X x) {
        this.removeValue(setIndex, x, -1);
    }

    public void removeValuesAfter(int setIndex, X x) {
        this.removeValue(setIndex, x, 1);
    }

    protected void removeValue(int setIndex, X x, int compareResult) {
        Iterator<Tuple2<X, Y>> i = this.values.get(setIndex).iterator();
        while (i.hasNext()) {
            Tuple2<X, Y> tuple = i.next();
            if (((Comparable)tuple.x).compareTo(x) != compareResult) continue;
            i.remove();
        }
        this.onChange();
    }

    public void disableChangeListeners() {
        this.disableChangeListeners = true;
    }

    public void enableChangeListeners() {
        this.disableChangeListeners = false;
    }

    public int getValueSets() {
        return this.values.size();
    }

    public Color getColor(int setIndex) {
        return this.colors.get(setIndex);
    }

    public boolean isFilled(int setIndex) {
        return this.filled.get(setIndex);
    }

    public List<Tuple2<X, Y>> getValues(int setIndex) {
        return this.values.get(setIndex);
    }

    public Tuple2<X, X> getHorizontalRange() {
        return this.horizontalRange;
    }

    public Tuple2<Y, Y> getVerticalRange() {
        return this.verticalRange;
    }

    public void setColor(int setIndex, Color color) {
        this.colors.set(setIndex, color);
    }

    public void setFilled(int setIndex, boolean f) {
        this.filled.set(setIndex, f);
    }

    public void setVerticalRange(Tuple2<Y, Y> verticalRange) {
        this.verticalRange = verticalRange;
        this.onChange();
    }
}

