/*
 * Decompiled with CFR 0.152.
 */
package timon.common.components.graph;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.image.BufferedImage;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import timon.common.collections.Tuple2;
import timon.common.components.graph.GraphModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Graph<X extends Comparable<X>, Y>
extends JPanel {
    private String title;
    private Font titleFont;
    private BufferedImage backgroundBuffer;
    private BufferedImage buffer;
    private Rectangle foregroundRect;
    private GraphModel<X, Y> model;
    private ChangeListener changeListener;

    public Graph(String title, GraphModel<X, Y> model) {
        this.title = title;
        this.titleFont = new Font("arial", 1, 10);
        this.changeListener = new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                Graph.this.onModelChanged();
            }
        };
        this.setModel(model);
    }

    protected void createBuffer(int w, int h) {
        if (this.buffer != null) {
            this.buffer.flush();
        }
        if (this.backgroundBuffer != null) {
            this.backgroundBuffer.flush();
        }
        this.buffer = new BufferedImage(w, h, 2);
        this.backgroundBuffer = new BufferedImage(w, h, 2);
        Graphics2D bgg = (Graphics2D)this.backgroundBuffer.getGraphics();
        bgg.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        this.foregroundRect = this.drawBackground(bgg);
        this.redraw();
    }

    protected void redraw() {
        BufferedImage buffer = this.getBuffer();
        if (buffer != null) {
            Graphics2D g = (Graphics2D)buffer.getGraphics();
            Rectangle r = this.foregroundRect;
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g.setBackground(new Color(0, 0, 0, 0));
            g.clearRect(0, 0, buffer.getWidth(), buffer.getHeight());
            g.drawImage((Image)this.backgroundBuffer, 0, 0, this);
            g.translate(r.x, r.y);
            this.drawForeground(g, r.width, r.height);
            this.drawLegend(g, r.width, r.height);
            g.translate(-r.x, -r.y);
        }
        this.repaint();
    }

    protected Rectangle drawBackground(Graphics2D g) {
        g.setBackground(new Color(0, 0, 0, 0));
        g.clearRect(0, 0, this.getWidth(), this.getHeight());
        int w = this.getWidth() - 10;
        int h = this.getHeight() - 10;
        g.translate(2, 2);
        g.translate(5, 5);
        g.setColor(new Color(0, 0, 0, 100));
        g.fillRoundRect(0, 0, w, h, 10, 10);
        g.translate(-5, -5);
        g.setColor(new Color(240, 240, 240));
        g.fillRoundRect(0, 0, w, h, 10, 10);
        g.setColor(new Color(200, 200, 200));
        g.drawRoundRect(0, 0, w, h, 10, 10);
        g.setColor(Color.BLACK);
        g.translate(-2, -2);
        Rectangle r = new Rectangle(18, 18, w - 30, h - 30);
        g.setPaint(new GradientPaint(r.x, r.y, new Color(255, 255, 255), r.x, r.y + r.height, new Color(240, 240, 240)));
        g.fillRect(r.x, r.y, r.width, r.height);
        return r;
    }

    protected void drawLegend(Graphics2D g, int w, int h) {
        List<Tuple2<X, Y>> values;
        Stroke oldStroke = g.getStroke();
        g.setStroke(new BasicStroke(2.0f));
        g.setColor(new Color(127, 127, 127));
        g.drawRect(0, 0, w - 1, h - 1);
        g.setStroke(oldStroke);
        g.setFont(this.titleFont);
        g.setColor(Color.BLACK);
        Rectangle bounds = g.getFontMetrics().getStringBounds(this.title, g).getBounds();
        g.drawString(this.title, (w - bounds.width) / 2, -4);
        if (this.getModel().getValueSets() > 0 && (values = this.getModel().getValues(0)).size() > 0) {
            String[] valueStringParts;
            int sy = 0;
            String valueString = this.getLabel(values.get((int)(values.size() - 1)).y);
            String[] stringArray = valueStringParts = valueString.split("\\\n");
            int n = valueStringParts.length;
            int n2 = 0;
            while (n2 < n) {
                String part = stringArray[n2];
                bounds = g.getFontMetrics().getStringBounds(part, g).getBounds();
                g.drawString(part, w - bounds.width - 6, sy + bounds.height);
                sy += bounds.height;
                ++n2;
            }
        }
    }

    protected void drawForeground(Graphics2D g, int w, int h) {
    }

    @Override
    public void paint(Graphics graphics) {
        if (this.buffer != null) {
            Graphics2D g = (Graphics2D)graphics;
            g.setBackground(this.getBackground());
            g.clearRect(0, 0, this.getWidth(), this.getHeight());
            g.drawImage((Image)this.buffer, 0, 0, this);
        }
    }

    protected void onModelChanged() {
        this.redraw();
    }

    public GraphModel<X, Y> getModel() {
        return this.model;
    }

    public String getLabel(Y value) {
        return String.valueOf(value);
    }

    protected Rectangle getForegroundRect() {
        return this.foregroundRect;
    }

    protected BufferedImage getBuffer() {
        return this.buffer;
    }

    @Override
    public void setBounds(int x, int y, int w, int h) {
        boolean sizeChanged = w != this.getWidth() || h != this.getHeight();
        super.setBounds(x, y, w, h);
        if (sizeChanged && w > 0 && h > 0) {
            this.createBuffer(w, h);
        }
    }

    public void setModel(GraphModel<X, Y> m) {
        if (this.model != m) {
            if (this.model != null) {
                this.model.removeChangeListener(this.changeListener);
            }
            this.model = m;
            if (this.model != null) {
                this.model.addChangeListener(this.changeListener);
            }
            this.onModelChanged();
        }
    }
}

