/*
 * Decompiled with CFR 0.152.
 */
package timon.common.components;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Arrays;

public class TableLayout
extends GridBagLayout {
    private GridBagConstraints constraints;
    private double[] relWidths;

    public TableLayout(int padh, int padv, int cols) {
        this(padh, padv, TableLayout.createRelWidths(cols));
    }

    public TableLayout(int padh, int padv, double ... relWidths) {
        this.relWidths = relWidths;
        this.constraints = new GridBagConstraints();
        this.constraints.fill = 1;
        this.constraints.insets = new Insets(padv, padh, padv, padh);
        this.constraints.gridx = 0;
        this.constraints.gridy = 0;
    }

    protected static double[] createRelWidths(int cols) {
        double[] result = new double[cols];
        Arrays.fill(result, 1.0 / (double)cols);
        return result;
    }

    public void addLayoutComponent(Component comp, Object constr) {
        this.constraints.weightx = this.relWidths[this.constraints.gridx];
        super.addLayoutComponent(comp, constr != null ? constr : this.constraints);
        this.constraints.gridx += this.constraints.gridwidth;
        if (this.constraints.gridx >= this.relWidths.length) {
            this.constraints.gridx = 0;
            ++this.constraints.gridy;
        }
    }

    public GridBagConstraints getConstraints() {
        return this.constraints;
    }
}

