/*
 * Decompiled with CFR 0.152.
 */
package timon.common.components;

import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.DocumentFilter;
import javax.swing.undo.UndoManager;
import timon.common.internal.Icons;
import timon.common.internal.Text;

public class TTextField
extends JTextField {
    private static final String PREFIX = "components.TTextField.";
    private static final String UNDO_ACTION_ID = "undo";
    private static final String REDO_ACTION_ID = "redo";
    private UndoManager undoManager;
    private boolean isUndoEnabled;
    private LimitedSizeFilter sizeFilter;
    private int maxLength = Integer.MAX_VALUE;

    public TTextField() {
        this(null, null, 0);
    }

    public TTextField(int columns) {
        this(null, null, columns);
    }

    public TTextField(String text) {
        this(null, text, 0);
    }

    public TTextField(String text, int columns) {
        this(null, text, columns);
    }

    public TTextField(Document document, String text, int columns) {
        super(document, text, columns);
        this.setUndoEnabled(true);
        this.sizeFilter = new LimitedSizeFilter();
        this.installContextMenu();
    }

    protected void installKeyboardShortcuts() {
        InputMap inputMap = this.getInputMap(0);
        ActionMap actionMap = this.getActionMap();
        inputMap.put(KeyStroke.getKeyStroke(90, 128), UNDO_ACTION_ID);
        actionMap.put(UNDO_ACTION_ID, new UndoAction());
        inputMap.put(KeyStroke.getKeyStroke(89, 128), REDO_ACTION_ID);
        actionMap.put(REDO_ACTION_ID, new RedoAction());
    }

    protected void uninstallKeyboardShortcuts() {
        InputMap inputMap = this.getInputMap(0);
        ActionMap actionMap = this.getActionMap();
        inputMap.remove(KeyStroke.getKeyStroke(90, 128));
        inputMap.remove(KeyStroke.getKeyStroke(89, 128));
        actionMap.remove(UNDO_ACTION_ID);
        actionMap.remove(REDO_ACTION_ID);
    }

    protected void installContextMenu() {
        this.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent event) {
                if (event.getButton() == 3) {
                    ActionMap actionMap = TTextField.this.getActionMap();
                    JPopupMenu popup = new JPopupMenu();
                    if (TTextField.this.isUndoEnabled()) {
                        JMenuItem undoItem = new JMenuItem(actionMap.get(TTextField.UNDO_ACTION_ID));
                        JMenuItem redoItem = new JMenuItem(actionMap.get(TTextField.REDO_ACTION_ID));
                        popup.add(undoItem);
                        popup.add(redoItem);
                        popup.addSeparator();
                    }
                    JMenuItem cutItem = new JMenuItem(actionMap.get("cut-to-clipboard"));
                    cutItem.setText(Text.get("components.TTextField.cut"));
                    cutItem.setIcon(Icons.get("components.TTextField.cutImage"));
                    JMenuItem copyItem = new JMenuItem(actionMap.get("copy-to-clipboard"));
                    copyItem.setText(Text.get("components.TTextField.copy"));
                    copyItem.setIcon(Icons.get("components.TTextField.copyImage"));
                    JMenuItem pasteItem = new JMenuItem(actionMap.get("paste-from-clipboard"));
                    pasteItem.setText(Text.get("components.TTextField.paste"));
                    pasteItem.setIcon(Icons.get("components.TTextField.pasteImage"));
                    popup.add(cutItem);
                    popup.add(copyItem);
                    popup.add(pasteItem);
                    popup.addSeparator();
                    JMenuItem selectAllItem = new JMenuItem(actionMap.get("select-all"));
                    selectAllItem.setText(Text.get("components.TTextField.selectAll"));
                    selectAllItem.setIcon(Icons.get("components.TTextField.selectAllImage"));
                    popup.add(selectAllItem);
                    popup.show(TTextField.this, event.getX(), event.getY());
                }
            }
        });
    }

    public boolean isUndoEnabled() {
        return this.isUndoEnabled;
    }

    public int getMaxLength() {
        return this.maxLength;
    }

    public void setMaxLength(int maxLength) {
        this.maxLength = maxLength;
    }

    public void setDocument(Document document) {
        Document oldDocument = this.getDocument();
        if (oldDocument != null) {
            oldDocument.removeUndoableEditListener(this.undoManager);
        }
        if (this.sizeFilter == null) {
            this.sizeFilter = new LimitedSizeFilter();
        }
        if (document instanceof AbstractDocument) {
            AbstractDocument ad = (AbstractDocument)document;
            this.sizeFilter.setDocumentFilter(ad.getDocumentFilter());
            ad.setDocumentFilter(this.sizeFilter);
        }
        super.setDocument(document);
        if (this.isUndoEnabled()) {
            document.addUndoableEditListener(this.undoManager);
        }
    }

    public void setUndoEnabled(boolean ue) {
        if (this.isUndoEnabled != ue) {
            this.isUndoEnabled = ue;
            if (this.isUndoEnabled) {
                this.undoManager = new UndoManager();
                this.getDocument().addUndoableEditListener(this.undoManager);
                this.installKeyboardShortcuts();
            } else {
                this.getDocument().removeUndoableEditListener(this.undoManager);
                this.undoManager = null;
                this.uninstallKeyboardShortcuts();
            }
        }
    }

    private class LimitedSizeFilter
    extends DocumentFilter {
        private DocumentFilter filter;

        public void insertString(DocumentFilter.FilterBypass fb, int offset, String text, AttributeSet attributeSet) throws BadLocationException {
            text = text.substring(0, Math.min(text.length(), TTextField.this.getMaxLength() - (offset + text.length())));
            if (this.filter != null) {
                this.filter.insertString(fb, offset, text, attributeSet);
            } else {
                super.insertString(fb, offset, text, attributeSet);
            }
        }

        public void setDocumentFilter(DocumentFilter filter) {
            this.filter = filter;
        }
    }

    private class RedoAction
    extends AbstractAction {
        public RedoAction() {
            this.putValue("Name", Text.get("components.TTextField.redo"));
            this.putValue("SmallIcon", Icons.get("components.TTextField.redoImage"));
        }

        public boolean isEnabled() {
            return TTextField.this.undoManager != null && TTextField.this.undoManager.canRedo();
        }

        public void actionPerformed(ActionEvent e) {
            if (TTextField.this.undoManager.canRedo()) {
                TTextField.this.undoManager.redo();
            }
        }
    }

    private class UndoAction
    extends AbstractAction {
        public UndoAction() {
            this.putValue("Name", Text.get("components.TTextField.undo"));
            this.putValue("SmallIcon", Icons.get("components.TTextField.undoImage"));
        }

        public boolean isEnabled() {
            return TTextField.this.undoManager != null && TTextField.this.undoManager.canUndo();
        }

        public void actionPerformed(ActionEvent e) {
            if (TTextField.this.undoManager.canUndo()) {
                TTextField.this.undoManager.undo();
            }
        }
    }
}

