/*
 * Decompiled with CFR 0.152.
 */
package timon.common.components;

import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.text.Document;
import javax.swing.undo.UndoManager;
import timon.common.internal.Icons;
import timon.common.internal.Text;

public class TTextArea
extends JTextArea {
    private static final String PREFIX = "components.TTextArea.";
    private static final String UNDO_ACTION_ID = "undo";
    private static final String REDO_ACTION_ID = "redo";
    private UndoManager undoManager;
    private boolean isUndoEnabled;

    public TTextArea() {
        this(null, "", 0, 0);
    }

    public TTextArea(Document doc) {
        super(doc);
    }

    public TTextArea(String text) {
        super(null, text, 0, 0);
    }

    public TTextArea(int rows, int columns) {
        this(null, "", rows, columns);
    }

    public TTextArea(String text, int rows, int columns) {
        this(null, text, rows, columns);
    }

    public TTextArea(Document doc, String text, int rows, int columns) {
        super(doc, text, rows, columns);
        this.setUndoEnabled(true);
        this.installContextMenu();
    }

    protected void installKeyboardShortcuts() {
        InputMap inputMap = this.getInputMap(0);
        ActionMap actionMap = this.getActionMap();
        inputMap.put(KeyStroke.getKeyStroke(90, 128), UNDO_ACTION_ID);
        actionMap.put(UNDO_ACTION_ID, new UndoAction());
        inputMap.put(KeyStroke.getKeyStroke(89, 128), REDO_ACTION_ID);
        actionMap.put(REDO_ACTION_ID, new RedoAction());
    }

    protected void uninstallKeyboardShortcuts() {
        InputMap inputMap = this.getInputMap(0);
        ActionMap actionMap = this.getActionMap();
        inputMap.remove(KeyStroke.getKeyStroke(90, 128));
        inputMap.remove(KeyStroke.getKeyStroke(89, 128));
        actionMap.remove(UNDO_ACTION_ID);
        actionMap.remove(REDO_ACTION_ID);
    }

    protected void installContextMenu() {
        this.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent event) {
                if (event.getButton() == 3) {
                    ActionMap actionMap = TTextArea.this.getActionMap();
                    JPopupMenu popup = new JPopupMenu();
                    if (TTextArea.this.isUndoEnabled()) {
                        JMenuItem undoItem = new JMenuItem(actionMap.get(TTextArea.UNDO_ACTION_ID));
                        JMenuItem redoItem = new JMenuItem(actionMap.get(TTextArea.REDO_ACTION_ID));
                        popup.add(undoItem);
                        popup.add(redoItem);
                        popup.addSeparator();
                    }
                    JMenuItem cutItem = new JMenuItem(actionMap.get("cut-to-clipboard"));
                    cutItem.setText(Text.get("components.TTextArea.cut"));
                    cutItem.setIcon(Icons.get("components.TTextArea.cutImage"));
                    JMenuItem copyItem = new JMenuItem(actionMap.get("copy-to-clipboard"));
                    copyItem.setText(Text.get("components.TTextArea.copy"));
                    copyItem.setIcon(Icons.get("components.TTextArea.copyImage"));
                    JMenuItem pasteItem = new JMenuItem(actionMap.get("paste-from-clipboard"));
                    pasteItem.setText(Text.get("components.TTextArea.paste"));
                    pasteItem.setIcon(Icons.get("components.TTextArea.pasteImage"));
                    popup.add(cutItem);
                    popup.add(copyItem);
                    popup.add(pasteItem);
                    popup.addSeparator();
                    JMenuItem selectAllItem = new JMenuItem(actionMap.get("select-all"));
                    selectAllItem.setText(Text.get("components.TTextArea.selectAll"));
                    selectAllItem.setIcon(Icons.get("components.TTextArea.selectAllImage"));
                    popup.add(selectAllItem);
                    popup.show(TTextArea.this, event.getX(), event.getY());
                }
            }
        });
    }

    public boolean isUndoEnabled() {
        return this.isUndoEnabled;
    }

    public void setDocument(Document document) {
        Document oldDocument = this.getDocument();
        if (oldDocument != null) {
            oldDocument.removeUndoableEditListener(this.undoManager);
        }
        super.setDocument(document);
        if (this.isUndoEnabled()) {
            document.addUndoableEditListener(this.undoManager);
        }
    }

    public void setUndoEnabled(boolean ue) {
        if (this.isUndoEnabled != ue) {
            this.isUndoEnabled = ue;
            this.getDocument().removeUndoableEditListener(this.undoManager);
            if (this.isUndoEnabled) {
                this.undoManager = new UndoManager();
                this.getDocument().addUndoableEditListener(this.undoManager);
            } else {
                this.undoManager = null;
            }
            this.uninstallKeyboardShortcuts();
        }
    }

    private class RedoAction
    extends AbstractAction {
        public RedoAction() {
            this.putValue("Name", Text.get("components.TTextArea.redo"));
            this.putValue("SmallIcon", Icons.get("components.TTextArea.redoImage"));
        }

        public boolean isEnabled() {
            return TTextArea.this.undoManager != null && TTextArea.this.undoManager.canRedo();
        }

        public void actionPerformed(ActionEvent e) {
            if (TTextArea.this.undoManager.canRedo()) {
                TTextArea.this.undoManager.redo();
            }
        }
    }

    private class UndoAction
    extends AbstractAction {
        public UndoAction() {
            this.putValue("Name", Text.get("components.TTextArea.undo"));
            this.putValue("SmallIcon", Icons.get("components.TTextArea.undoImage"));
        }

        public boolean isEnabled() {
            return TTextArea.this.undoManager != null && TTextArea.this.undoManager.canUndo();
        }

        public void actionPerformed(ActionEvent e) {
            if (TTextArea.this.undoManager.canUndo()) {
                TTextArea.this.undoManager.undo();
            }
        }
    }
}

