/*
 * Decompiled with CFR 0.152.
 */
package timon.common.components;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.Window;
import java.io.File;
import java.util.Locale;
import javax.swing.JFileChooser;
import javax.swing.UIManager;
import javax.swing.filechooser.FileFilter;

public class TFileChooser {
    public static final int OK_OPTION = 0;
    public static final int CANCEL_OPTION = -1;
    private String path;
    private Mode mode;
    private DialogType dialogType;
    private FileFilter fileFilter;
    private File selectedFile;

    public TFileChooser() {
        this(null);
    }

    public TFileChooser(String path) {
        this.path = path;
        this.mode = Mode.OPEN;
        this.dialogType = DialogType.AWT;
    }

    public int showDialog(Component component) {
        this.selectedFile = null;
        if (this.dialogType == DialogType.AWT) {
            Container root = null;
            if (component != null) {
                root = TFileChooser.getWindowFor(component);
            }
            FileDialog dialog = null;
            if (root instanceof Dialog) {
                dialog = new FileDialog((Dialog)root);
            } else if (root instanceof Frame) {
                dialog = new FileDialog((Frame)root);
            }
            if (dialog == null) {
                throw new IllegalArgumentException("Trying to show a file chooser on an invalid container. Root component must be attached to a frame or dialog.");
            }
            Locale locale = dialog.getLocale();
            if (this.mode == Mode.OPEN) {
                dialog.setTitle(UIManager.getString((Object)"FileChooser.openDialogTitleText", locale));
                dialog.setMode(0);
            } else {
                dialog.setTitle(UIManager.getString((Object)"FileChooser.saveDialogTitleText", locale));
                dialog.setMode(1);
            }
            if (this.path != null) {
                File file = new File(this.path);
                if (file.getParentFile() != null) {
                    dialog.setDirectory(file.getParentFile().getAbsolutePath());
                }
                dialog.setFile(file.getName());
            }
            dialog.setLocationRelativeTo(component);
            dialog.setVisible(true);
            String dirPath = dialog.getDirectory();
            String filePath = dialog.getFile();
            if (filePath == null) {
                return -1;
            }
            this.selectedFile = new File(String.valueOf(dirPath) + File.separator + filePath);
            return 0;
        }
        if (this.dialogType == DialogType.SWING) {
            JFileChooser dialog = new JFileChooser(this.path);
            dialog.setFileFilter(this.fileFilter);
            int result = 0;
            result = this.mode == Mode.OPEN ? dialog.showOpenDialog(component) : dialog.showSaveDialog(component);
            if (result != 0) {
                return -1;
            }
            this.selectedFile = dialog.getSelectedFile();
            return 0;
        }
        throw new IllegalArgumentException("Invalid dialogType: " + (Object)((Object)this.dialogType));
    }

    protected static Container getWindowFor(Component component) {
        while (!(component instanceof Container)) {
            component = component.getParent();
        }
        Container container = (Container)component;
        while (container != null) {
            if (container instanceof Window) {
                return container;
            }
            container = container.getParent();
        }
        return null;
    }

    public String getPath() {
        return this.path;
    }

    public Mode getMode() {
        return this.mode;
    }

    public DialogType getDialogType() {
        return this.dialogType;
    }

    public File getSelectedFile() {
        return this.selectedFile;
    }

    public FileFilter getFileFilter() {
        return this.fileFilter;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setMode(Mode mode) {
        if (mode == null) {
            throw new IllegalArgumentException("Mode cannot be null");
        }
        this.mode = mode;
    }

    public void setDialogType(DialogType dialogType) {
        if (dialogType == null) {
            throw new IllegalArgumentException("DialogType cannot be null");
        }
        this.dialogType = dialogType;
    }

    public void setFileFilter(FileFilter fileFilter) {
        this.fileFilter = fileFilter;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum DialogType {
        AWT,
        SWING;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Mode {
        OPEN,
        SAVE;

    }
}

