/*
 * Decompiled with CFR 0.152.
 */
package timon.common.components;

import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.awt.image.BufferedImage;
import java.util.Arrays;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import timon.common.components.MessageBox;
import timon.common.internal.Text;

public class TColorChooser {
    private Color color;
    private JPanel mainPanel;
    private ColorField colorField;
    private HueSlider hueSlider;
    private PreviewPanel previewPanel;

    public TColorChooser() {
        this(Color.BLACK);
    }

    public TColorChooser(Color initialColor) {
        this.color = initialColor;
        this.mainPanel = this.createMainPanel();
        this.setColor(this.color);
    }

    public static final void main(String[] args) {
        new TColorChooser(new Color(100, 100, 200)).showMessage(null, "blarf");
    }

    public Color showMessage(Component parent, String title) {
        MessageBox popup = new MessageBox(title, this.mainPanel);
        popup.addButton(Text.get("ok"), Text.get("ok"));
        popup.addButton(Text.get("cancel"), Text.get("cancel"));
        if (popup.showMessage(parent) == 0) {
            return this.color;
        }
        return null;
    }

    protected JPanel createMainPanel() {
        this.colorField = new ColorField();
        this.colorField.setPreferredSize(new Dimension(200, 200));
        this.hueSlider = new HueSlider();
        this.hueSlider.setPreferredSize(new Dimension(25, 200));
        JPanel colorPanel = new JPanel(new BorderLayout(5, 5));
        colorPanel.add((Component)this.colorField, "Center");
        colorPanel.add((Component)this.hueSlider, "East");
        this.previewPanel = new PreviewPanel();
        this.previewPanel.setPreferredSize(new Dimension(96, 48));
        this.previewPanel.setOldColor(this.color);
        JPanel panel = new JPanel(new BorderLayout(5, 5));
        panel.setBorder(new EmptyBorder(5, 5, 5, 5));
        panel.add((Component)colorPanel, "West");
        panel.add((Component)this.previewPanel, "South");
        return panel;
    }

    public void setColor(Color color) {
        this.color = color;
        this.previewPanel.setNewColor(color);
        this.colorField.setColor(color);
    }

    private class ColorField
    extends JComponent {
        private BufferedImage image;
        private int disableInput;
        private float hue;
        private Point cursorPos;

        public ColorField() {
            this.setBorder(new LineBorder(new Color(127, 127, 127)));
            this.addMouseListener(new MouseAdapter(){

                public void mousePressed(MouseEvent event) {
                    ColorField.this.mouseEvent(event);
                }
            });
            this.addMouseMotionListener(new MouseMotionListener(){

                public void mouseDragged(MouseEvent event) {
                    ColorField.this.mouseEvent(event);
                }

                public void mouseMoved(MouseEvent event) {
                }
            });
        }

        protected void mouseEvent(MouseEvent event) {
            int w = this.getWidth();
            int h = this.getHeight();
            int x = Math.max(0, Math.min(w - 1, event.getX()));
            int y = Math.max(0, Math.min(h - 1, event.getY()));
            this.setCursorLocation(x, y);
        }

        public void paint(Graphics graphics) {
            Graphics2D g = (Graphics2D)graphics;
            int w = this.getWidth();
            int h = this.getHeight();
            g.setBackground(this.getBackground());
            g.clearRect(0, 0, w, h);
            if (this.image != null) {
                g.drawImage((Image)this.image, 0, 0, this);
            }
            if (this.cursorPos != null) {
                g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                int s = 10;
                g.setColor(Color.WHITE);
                g.setStroke(new BasicStroke(2.0f));
                g.drawOval(this.cursorPos.x - s / 2, this.cursorPos.y - s / 2, s, s);
            }
            this.paintBorder(g);
        }

        public void redraw() {
            if (this.disableInput > 0) {
                return;
            }
            if (this.image != null) {
                int w = this.image.getWidth();
                int h = this.image.getHeight();
                int[] pixels = new int[w * h];
                int t = 0;
                float val = 1.0f;
                float satInc = -1.0f / (float)w;
                float valInc = -1.0f / (float)h;
                int y = 0;
                while (y < h) {
                    float sat = 1.0f;
                    int x = 0;
                    while (x < w) {
                        pixels[t] = Color.HSBtoRGB(this.hue, sat, val);
                        sat += satInc;
                        ++t;
                        ++x;
                    }
                    val += valInc;
                    ++y;
                }
                this.image.setRGB(0, 0, w, h, pixels, 0, w);
                this.repaint();
            }
        }

        public float getHue() {
            return this.hue;
        }

        public void setBounds(int x, int y, int w, int h) {
            if (w != this.getWidth() || h != this.getHeight()) {
                this.image = null;
                this.cursorPos = null;
            }
            super.setBounds(x, y, w, h);
            if (this.image == null && w > 0 && h > 0) {
                this.image = new BufferedImage(w, h, 1);
                this.setColor(TColorChooser.this.color);
            }
        }

        public void setHue(float h) {
            this.hue = Math.max(0.0f, Math.min(1.0f, h));
            this.redraw();
            if (this.disableInput == 0 && this.cursorPos != null) {
                ++this.disableInput;
                TColorChooser.this.setColor(new Color(this.image.getRGB(this.cursorPos.x, this.cursorPos.y)));
                --this.disableInput;
            }
        }

        public void setColor(Color c) {
            if (this.disableInput > 0) {
                return;
            }
            ++this.disableInput;
            float[] hsb = Color.RGBtoHSB(c.getRed(), c.getGreen(), c.getBlue(), null);
            this.setHue(hsb[0]);
            int w = this.getWidth();
            int h = this.getHeight();
            this.setCursorLocation(Math.round((float)w * (1.0f - hsb[1])), Math.round((float)h * (1.0f - hsb[2])));
            --this.disableInput;
            this.redraw();
        }

        public void setCursorLocation(int x, int y) {
            x = Math.max(0, Math.min(this.getWidth() - 1, x));
            y = Math.max(0, Math.min(this.getHeight() - 1, y));
            if (this.cursorPos != null && this.cursorPos.x == x && this.cursorPos.y == y) {
                return;
            }
            this.cursorPos = new Point(x, y);
            if (this.disableInput == 0) {
                ++this.disableInput;
                TColorChooser.this.setColor(new Color(this.image.getRGB(x, y)));
                --this.disableInput;
            }
            this.repaint();
        }
    }

    private class HueSlider
    extends JComponent {
        private BufferedImage image;

        public HueSlider() {
            this.setBorder(new LineBorder(new Color(127, 127, 127)));
            this.addMouseListener(new MouseAdapter(){

                public void mousePressed(MouseEvent event) {
                    HueSlider.this.mouseEvent(event);
                }
            });
            this.addMouseMotionListener(new MouseMotionListener(){

                public void mouseDragged(MouseEvent event) {
                    HueSlider.this.mouseEvent(event);
                }

                public void mouseMoved(MouseEvent event) {
                }
            });
        }

        protected void mouseEvent(MouseEvent event) {
            int y = Math.max(0, Math.min(this.getInnerHeight() - 1, event.getY()));
            TColorChooser.this.colorField.setHue((float)y / (float)(this.getInnerHeight() - 1));
            this.repaint();
        }

        protected void paintComponent(Graphics graphics) {
            Graphics2D g = (Graphics2D)graphics;
            int w = this.getInnerWidth();
            int h = this.getInnerHeight();
            Insets i = this.getInsets();
            g.translate(i.left, i.top);
            if (this.image != null) {
                g.drawImage((Image)this.image, 0, 0, this);
            }
            int ly = (int)(TColorChooser.this.colorField.getHue() * (float)(h - 1));
            g.setColor(Color.WHITE);
            g.drawLine(0, ly, w - 1, ly);
            g.drawLine(0, ly + 1, w - 1, ly + 1);
            g.translate(-i.left, -i.top);
            this.paintBorder(g);
        }

        protected BufferedImage createImage() {
            int w = this.getInnerWidth();
            int h = this.getInnerHeight();
            BufferedImage result = new BufferedImage(w, h, 1);
            int[] data = new int[w * h];
            int t = 0;
            float hue = 0.0f;
            float hueInc = 1.0f / (float)h;
            int y = 0;
            while (y < h) {
                int v = Color.HSBtoRGB(hue, 0.85f, 0.85f);
                Arrays.fill(data, t, t + w, v);
                hue += hueInc;
                t += w;
                ++y;
            }
            result.setRGB(0, 0, w, h, data, 0, w);
            return result;
        }

        protected int getInnerWidth() {
            return this.getWidth() - this.getInsets().left - this.getInsets().right;
        }

        protected int getInnerHeight() {
            return this.getHeight() - this.getInsets().top - this.getInsets().bottom;
        }

        public void setBounds(int x, int y, int w, int h) {
            if (w != this.getWidth() || w != this.getHeight()) {
                this.image = null;
            }
            super.setBounds(x, y, w, h);
            if (this.image == null && w > 0 && h > 0) {
                this.image = this.createImage();
                this.repaint();
            }
        }
    }

    private class PreviewPanel
    extends JComponent {
        private Color oldColor = Color.BLACK;
        private Color newColor = Color.BLACK;

        public PreviewPanel() {
            this.setBorder(new LineBorder(new Color(127, 127, 127)));
        }

        public void paint(Graphics graphics) {
            Graphics2D g = (Graphics2D)graphics;
            int w = this.getWidth();
            int h = this.getHeight();
            g.setColor(this.oldColor);
            g.fillRect(0, 0, w / 2, h);
            g.setColor(this.newColor);
            g.fillRect(w / 2, 0, w - w / 2, h);
            this.paintBorder(g);
        }

        public void setOldColor(Color color) {
            this.oldColor = color;
            this.repaint();
        }

        public void setNewColor(Color color) {
            this.newColor = color;
            this.repaint();
        }
    }
}

