/*
 * Decompiled with CFR 0.152.
 */
package timon.common.components;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.net.URL;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JTextField;
import javax.swing.JWindow;
import javax.swing.border.EmptyBorder;
import timon.common.Log;

public class SplashScreen {
    private JWindow window = new JWindow();
    protected JTextField messageField;
    protected JProgressBar loadingField;

    public SplashScreen(URL url) {
        this(url, 512, 192);
    }

    public SplashScreen(URL url, int w, int h) {
        this.window.setFocusable(false);
        this.window.setFocusableWindowState(false);
        JLabel imageField = new JLabel();
        imageField.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent event) {
                SplashScreen.this.dispose();
            }
        });
        imageField.setPreferredSize(new Dimension(w, h));
        try {
            BufferedImage image = ImageIO.read(url);
            imageField.setIcon(new ImageIcon(image));
        }
        catch (IOException ioe) {
            Log.warning(ioe);
        }
        catch (IllegalArgumentException iae) {
            Log.warning(iae);
        }
        this.loadingField = new JProgressBar();
        this.messageField = new JTextField();
        this.messageField.setOpaque(false);
        this.messageField.setBorder(new EmptyBorder(5, 5, 5, 5));
        imageField.setLayout(new BorderLayout());
        imageField.add((Component)this.messageField, "South");
        JPanel messagePanel = new JPanel(new GridLayout(2, 1));
        messagePanel.setBackground(new Color(250, 250, 250));
        messagePanel.add(this.loadingField);
        Container c = this.window.getContentPane();
        c.setLayout(new BorderLayout());
        c.add((Component)imageField, "Center");
        c.add((Component)messagePanel, "South");
        this.window.pack();
        this.window.setLocation((this.window.getToolkit().getScreenSize().width - this.window.getWidth()) / 2, (this.window.getToolkit().getScreenSize().height - this.window.getHeight()) / 2);
        this.window.setVisible(true);
    }

    public void dispose() {
        if (this.window.isDisplayable()) {
            this.window.dispose();
        }
    }

    public void messageChanged(String message, int progress) {
        this.messageField.setText(message);
        this.loadingField.setValue(progress);
        if (this.window.isDisplayable()) {
            this.window.requestFocus();
        }
    }
}

