/*
 * Decompiled with CFR 0.152.
 */
package timon.common.components;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import javax.swing.JComponent;
import javax.swing.SwingConstants;
import javax.swing.border.EmptyBorder;
import timon.common.GraphicsUtil;

public class Sash
extends JComponent
implements SwingConstants {
    private int orientation;

    public Sash(int orientation) {
        this(orientation, -1);
    }

    public Sash(int orientation, int size) {
        this.orientation = orientation;
        if (size > 0) {
            if (orientation == 1) {
                this.setPreferredSize(new Dimension(1, size));
            } else {
                this.setPreferredSize(new Dimension(size, 1));
            }
        }
        this.setBorder(new EmptyBorder(2, 2, 2, 2));
        this.setForeground(new Color(127, 127, 127));
    }

    protected void paintComponent(Graphics graphics) {
        int w = this.getWidth();
        int h = this.getHeight();
        Graphics2D g = (Graphics2D)graphics;
        Color c = this.getForeground();
        if (this.orientation == 1) {
            g.setPaint(new GradientPaint(0.0f, 0.0f, GraphicsUtil.setAlpha(c, 0), 0.0f, h / 2, GraphicsUtil.setAlpha(c, 170)));
            g.fillRect(0, 0, w, h / 2);
            g.setPaint(new GradientPaint(0.0f, h, GraphicsUtil.setAlpha(c, 0), 0.0f, h / 2, GraphicsUtil.setAlpha(c, 170)));
            g.fillRect(0, h / 2, w, h / 2);
        } else {
            g.setPaint(new GradientPaint(0.0f, 0.0f, GraphicsUtil.setAlpha(c, 0), w / 2, 0.0f, GraphicsUtil.setAlpha(c, 170)));
            g.fillRect(0, 0, w / 2, h);
            g.setPaint(new GradientPaint(w, 0.0f, GraphicsUtil.setAlpha(c, 0), w / 2, 0.0f, GraphicsUtil.setAlpha(c, 170)));
            g.fillRect(w / 2, 0, w / 2, h);
        }
    }
}

