/*
 * Decompiled with CFR 0.152.
 */
package timon.common.components;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import timon.common.components.GuiUtil;

public class MessageBox {
    protected int selectedOption;
    protected List<ActionListener> listeners;
    private String title;
    private int optionButtonWidth;
    private JPanel panel;
    private OptionPanel optionPanel;

    public MessageBox() {
        this(null);
    }

    public MessageBox(String title) {
        this(title, null);
    }

    public MessageBox(String title, Object message) {
        if (title != null) {
            this.title = title;
        }
        this.selectedOption = -1;
        this.listeners = new ArrayList<ActionListener>();
        this.optionButtonWidth = 400;
        this.panel = new JPanel();
        this.panel.setLayout(new BorderLayout());
        if (message instanceof JComponent) {
            this.panel.add((JComponent)message);
        } else if (message != null) {
            JLabel label = new JLabel("<html><div style='width: " + this.getButtonWidth() + "'>" + message.toString() + "</div></html>");
            JPanel labelPanel = new JPanel(new FlowLayout(0));
            labelPanel.setBackground(new Color(240, 240, 240));
            labelPanel.add(label);
            JPanel labelPanel2 = new JPanel(new BorderLayout());
            labelPanel2.setBorder(new EmptyBorder(10, 10, 5, 10));
            labelPanel2.add((Component)labelPanel, "Center");
            this.panel.add((Component)labelPanel2, "Center");
        }
        this.createOptionPanel();
    }

    public static void main(String[] args) {
        int x;
        String d;
        String dp;
        try {
            GuiUtil.setSkin("timon.plaf.platinum.PlatinumLookAndFeel");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        MessageBox mb = new MessageBox("title TeSt", "mnefds dsk nsajd sdhasjd hask ajdska jdklasdj askl djaskldjaskl jaskldjs kldjaskldj askldj askljd askljdkl asjdklasj dklasj d asklj daskl djkldasj kldasj kldasjkldasjdkl asjdklas jdklasjdaskldj askldjasklj daskldjaskl djaskldj lajskldjskl dj");
        int n = 0;
        while (n < 3) {
            dp = "Desciption " + n + " ";
            d = "";
            x = 0;
            while (x < (n + 3) * 5) {
                d = String.valueOf(d) + dp;
                ++x;
            }
            mb.addOption("Option " + n, d);
            ++n;
        }
        n = 0;
        while (n < 5) {
            dp = "Desciption " + n + " ";
            d = "";
            x = 0;
            while (x < n * 5) {
                d = String.valueOf(d) + dp;
                ++x;
            }
            mb.addButton("Button " + n, d);
            ++n;
        }
        System.out.println("Selected Option = " + mb.showMessage());
    }

    public void fireButtonPress(int index) {
        this.buttonPressed(index);
    }

    public int showMessage() {
        return this.showMessage(null);
    }

    public int showMessage(Component component) {
        final JDialog dialog = component != null ? new JDialog(JOptionPane.getFrameForComponent(component)) : new JDialog();
        this.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                dialog.setVisible(false);
            }
        });
        this.optionPanel.setButtonsCentered(this.optionPanel.getNonButtonOptionCount() == 0);
        dialog.add(this.panel);
        dialog.pack();
        dialog.setLocationRelativeTo(component);
        dialog.setTitle(this.title);
        dialog.setResizable(false);
        dialog.setModal(true);
        dialog.setVisible(true);
        dialog.dispose();
        return this.selectedOption;
    }

    protected void buttonPressed(int index) {
        this.selectedOption = index;
        this.notifyListeners(index);
    }

    protected void createOptionPanel() {
        this.optionPanel = new OptionPanel(true);
        this.panel.add((Component)this.optionPanel, "South");
    }

    public void addOption(String option, String description) {
        this.optionPanel.addOption(option, description);
    }

    public void addButton(String option, String description) {
        this.optionPanel.addButton(option, description);
    }

    public void addActionListener(ActionListener al) {
        this.listeners.add(al);
    }

    public void removeActionListener(ActionListener al) {
        this.listeners.remove(al);
    }

    public void notifyListeners(int selectedIndex) {
        ActionEvent event = new ActionEvent(this, selectedIndex, "buttonPressed");
        ActionListener[] l = new ActionListener[this.listeners.size()];
        this.listeners.toArray(l);
        ActionListener[] actionListenerArray = l;
        int n = l.length;
        int n2 = 0;
        while (n2 < n) {
            ActionListener al = actionListenerArray[n2];
            al.actionPerformed(event);
            ++n2;
        }
    }

    public int getButtonWidth() {
        return this.optionButtonWidth;
    }

    public String getTitle() {
        return this.title;
    }

    public void setButtonWidth(int buttonWidth) {
        this.optionButtonWidth = buttonWidth;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void removeAllOptions() {
        if (this.optionPanel != null) {
            this.panel.remove(this.optionPanel);
        }
        this.createOptionPanel();
    }

    private class OptionPanel
    extends JPanel {
        private List<String> options = new ArrayList<String>();
        private List<String> descriptions = new ArrayList<String>();
        private JPanel optionPanel = new JPanel();
        private JPanel buttonPanel;
        private LayoutManager layout;

        public OptionPanel(boolean makeButtonsEqualSize) {
            this.optionPanel.setMaximumSize(new Dimension(600, 9999));
            this.optionPanel.setBorder(new EmptyBorder(10, 10, 10, 10));
            this.optionPanel.setVisible(false);
            this.layout = makeButtonsEqualSize ? new GridLayout(-1, 1, 5, 5) : new BoxLayout(this.optionPanel, 1);
            this.optionPanel.setLayout(this.layout);
            this.buttonPanel = new JPanel(new FlowLayout(2));
            this.buttonPanel.setVisible(false);
            this.setLayout(new BoxLayout(this, 1));
            this.add(this.optionPanel);
            this.add(this.buttonPanel);
        }

        public void addButton(String option, String description) {
            this.addOption2(option, description, true);
        }

        public void addOption(String option, String description) {
            this.addOption2(option, description, false);
        }

        public void addOption2(String option, String description, boolean asButton) {
            JButton button;
            final int index = this.options.size();
            if (option == null) {
                option = "";
            }
            if (description == null) {
                description = "";
            }
            this.options.add(option);
            this.descriptions.add(description);
            if (asButton) {
                button = new JButton(option);
                button.setToolTipText(description);
            } else {
                button = new JButton("<html><b>" + option + "</b><br><br><div style='width: " + MessageBox.this.getButtonWidth() + "'>" + description + "</p></html>"){

                    public void paint(Graphics graphics) {
                        Graphics2D g = (Graphics2D)graphics;
                        int w = this.getWidth();
                        int h = this.getHeight();
                        g.setBackground(this.getParent().getBackground());
                        g.clearRect(0, 0, w, h);
                        if (!this.model.isRollover()) {
                            Color c1 = new Color(240, 240, 240, 127);
                            Color c2 = new Color(127, 127, 127, 127);
                            GuiUtil.drawSelectionRect(g, 0, 0, w, h, c1, c2);
                        } else {
                            GuiUtil.drawGradientSelectionRect(g, 0, 0, w, h);
                        }
                        if (this.model.isArmed()) {
                            g.translate(1, 1);
                        }
                        super.paint(g);
                        if (this.model.isArmed()) {
                            g.translate(-1, -1);
                        }
                    }
                };
                button.setCursor(Cursor.getPredefinedCursor(12));
                button.setBorder(new EmptyBorder(5, 5, 5, 5));
                button.setOpaque(false);
                button.setBackground(new Color(0, 0, 0, 0));
            }
            button.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent event) {
                    MessageBox.this.buttonPressed(index);
                }
            });
            if (asButton) {
                this.buttonPanel.setVisible(true);
                this.buttonPanel.add(button);
            } else {
                this.optionPanel.setVisible(true);
                if (index > 0 && this.layout instanceof BoxLayout) {
                    this.optionPanel.add(Box.createVerticalStrut(5));
                }
                button.setMinimumSize(new Dimension(MessageBox.this.getButtonWidth(), 1));
                this.optionPanel.add(button);
            }
        }

        public int getNonButtonOptionCount() {
            return this.optionPanel.getComponentCount();
        }

        public void setButtonsCentered(boolean centered) {
            FlowLayout layout = (FlowLayout)this.buttonPanel.getLayout();
            layout.setAlignment(centered ? 1 : 2);
            this.validate();
        }
    }
}

