/*
 * Decompiled with CFR 0.152.
 */
package timon.common.components;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import timon.common.GraphicsUtil;
import timon.common.Log;

public abstract class IconTreeCellRenderer
extends DefaultTreeCellRenderer {
    private final ImageIcon icon;

    public IconTreeCellRenderer() {
        this(16, 16);
    }

    public IconTreeCellRenderer(final int w, final int h) {
        this.icon = new ImageIcon(){

            public void paintIcon(Component c, Graphics graphics, int x, int y) {
                Image i = this.getImage();
                Dimension d = GraphicsUtil.getProportionalScale(i.getWidth(null), i.getHeight(null), w, h);
                Graphics2D g = (Graphics2D)graphics;
                g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
                g.drawImage(this.getImage(), x + (w - d.width) / 2, y + (h - d.height) / 2, d.width, d.height, null);
            }

            public int getIconWidth() {
                return w;
            }

            public int getIconHeight() {
                return h;
            }
        };
    }

    public abstract Image getImageFor(Object var1);

    public abstract String getLabelFor(Object var1);

    public JLabel decorateLabel(JLabel label, Object value) {
        Image image;
        if (value instanceof DefaultMutableTreeNode) {
            value = ((DefaultMutableTreeNode)value).getUserObject();
        }
        if ((image = this.getImageFor(value)) != null) {
            this.icon.setImage(image);
            label.setIcon(this.icon);
        } else {
            label.setIcon(null);
        }
        label.setText(this.getLabelFor(value));
        return label;
    }

    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        Component c = super.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, hasFocus);
        if (c instanceof JLabel) {
            return this.decorateLabel((JLabel)c, value);
        }
        Log.warning("Component returned by DefaultTreeCellRenderer is not a JLabel, but a " + c.getClass());
        return c;
    }
}

