/*
 * Decompiled with CFR 0.152.
 */
package timon.common.components;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.table.DefaultTableCellRenderer;
import timon.common.GraphicsUtil;
import timon.common.Log;

public abstract class IconTableCellRenderer
extends DefaultTableCellRenderer {
    private static final Border noFocusBorder = new EmptyBorder(1, 1, 1, 1);
    private final ImageIcon icon;

    public IconTableCellRenderer() {
        this(16, 16);
    }

    public IconTableCellRenderer(final int w, final int h) {
        this.icon = new ImageIcon(){

            public void paintIcon(Component c, Graphics graphics, int x, int y) {
                Image i = this.getImage();
                Dimension d = GraphicsUtil.getProportionalScale(i.getWidth(null), i.getHeight(null), w, h);
                Graphics2D g = (Graphics2D)graphics;
                g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
                g.drawImage(this.getImage(), x + (w - d.width) / 2, y + (h - d.height) / 2, d.width, d.height, null);
            }

            public int getIconWidth() {
                return w;
            }

            public int getIconHeight() {
                return h;
            }
        };
        this.setFont(UIManager.getFont("TextField.font"));
    }

    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean cellHasFocus, int row, int column) {
        Component c = super.getTableCellRendererComponent(table, value, isSelected, cellHasFocus, row, column);
        if (c instanceof JLabel) {
            JLabel label = (JLabel)c;
            if (isSelected) {
                label.setForeground(table.getSelectionForeground());
                label.setBackground(table.getSelectionBackground());
            } else {
                label.setForeground(table.getForeground());
                label.setBackground(table.getBackground());
            }
            if (cellHasFocus) {
                label.setBorder(UIManager.getBorder("Table.focusCellHighlightBorder"));
            } else {
                label.setBorder(noFocusBorder);
            }
            return this.decorateLabel(label, value);
        }
        Log.warning("Component returned by DefaultTableCellRenderer is not a JLabel, but a " + c.getClass());
        return c;
    }

    public JLabel decorateLabel(JLabel label, Object value) {
        Image image = this.getImageFor(value);
        if (image != null) {
            this.icon.setImage(image);
            label.setIcon(this.icon);
        } else {
            label.setIcon(null);
        }
        label.setText(this.getLabelFor(value));
        return label;
    }

    public abstract Image getImageFor(Object var1);

    public abstract String getLabelFor(Object var1);
}

