/*
 * Decompiled with CFR 0.152.
 */
package timon.common.components;

import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import javax.swing.ImageIcon;
import timon.common.GraphicsUtil;
import timon.common.Log;
import timon.common.OtherUtil;

public class IconLoader {
    private static IconLoader defaultInstance;
    private String id;
    private DebugLevel debugLevel;
    private HashMap<String, BufferedImage> imageCache;

    public IconLoader(String id) {
        this.id = id;
        this.imageCache = new HashMap();
        this.debugLevel = DebugLevel.WARNING;
    }

    public static IconLoader getDefault() {
        if (defaultInstance == null) {
            defaultInstance = new IconLoader("default");
        }
        return defaultInstance;
    }

    public void clearCache() {
        this.imageCache.clear();
    }

    protected void verbose(String text) {
        if (this.debugLevel == DebugLevel.VERBOSE) {
            Log.verbose("[IconLoader." + this.id + "] " + text);
        }
    }

    protected void warning(String text) {
        if (this.debugLevel == DebugLevel.VERBOSE || this.debugLevel == DebugLevel.WARNING) {
            Log.warning("[IconLoader." + this.id + "] " + text);
        }
    }

    public static ImageIcon getIcon(String filename) {
        return IconLoader.getIcon(filename, null);
    }

    public static ImageIcon getIcon(String filename, InputStream in) {
        return IconLoader.getDefault().getIcon2(filename, in);
    }

    public static BufferedImage getImage(String filename) {
        return IconLoader.getImage(filename, null);
    }

    public static BufferedImage getImage(String filename, InputStream in) {
        return IconLoader.getDefault().getImage2(filename, in);
    }

    public ImageIcon getIcon2(String filename) {
        return this.getIcon2(filename, null);
    }

    public ImageIcon getIcon2(String filename, InputStream in) {
        BufferedImage image = this.getImage2(filename, in);
        if (image != null) {
            return new ImageIcon(image);
        }
        return new ImageIcon();
    }

    public BufferedImage getImage2(String filename) {
        return this.getImage2(filename, null);
    }

    public BufferedImage getImage2(String filename, InputStream in) {
        return this.getImageMaster(filename, in, true);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected BufferedImage getImageMaster(String filename, InputStream in, boolean blockUntilLoaded) {
        BufferedImage image = null;
        if (this.imageCache.containsKey(filename)) {
            return this.imageCache.get(filename);
        }
        long time = System.currentTimeMillis();
        this.imageCache.put(filename, null);
        try {
            if (in == null) {
                File file = new File(filename);
                if (!file.exists() || !file.canRead()) {
                    this.warning("No image found (" + filename + ")");
                    return null;
                }
                in = new FileInputStream(file);
                image = GraphicsUtil.getImage(in);
                in.close();
            } else {
                image = GraphicsUtil.getImage(in);
            }
        }
        catch (IOException ioe) {
            this.warning("Failed loading image (" + filename + ")");
            return null;
        }
        this.imageCache.put(filename, image);
        this.verbose("Finished loading image " + (System.currentTimeMillis() - time) + "ms :: " + OtherUtil.round((double)new File(filename).length() / 1024.0, 2) + "KB :: image (" + filename + ")");
        this.verbose("Memory Used " + this.getMemoryUsage() / 1024L + "KB");
        return image;
    }

    private long getMemoryUsage() {
        long usage = 0L;
        for (Image image : this.imageCache.values()) {
            if (image == null) continue;
            int colorDepth = 24;
            if (image instanceof RenderedImage) {
                colorDepth = ((RenderedImage)((Object)image)).getColorModel().getPixelSize();
            }
            usage += (long)(image.getWidth(null) * image.getHeight(null) * colorDepth / 8);
        }
        return usage;
    }

    public void setDebugLevel(DebugLevel level) {
        this.debugLevel = level;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum DebugLevel {
        VERBOSE,
        WARNING;

    }
}

