/*
 * Decompiled with CFR 0.152.
 */
package timon.common.components;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import javax.swing.DefaultListCellRenderer;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JList;
import timon.common.GraphicsUtil;
import timon.common.Log;

public abstract class IconListCellRenderer
extends DefaultListCellRenderer {
    private final ImageIcon icon;

    public IconListCellRenderer() {
        this(16, 16);
    }

    public IconListCellRenderer(final int w, final int h) {
        this.icon = new ImageIcon(){

            public void paintIcon(Component c, Graphics graphics, int x, int y) {
                Image i = this.getImage();
                Dimension d = GraphicsUtil.getProportionalScale(i.getWidth(null), i.getHeight(null), w, h);
                Graphics2D g = (Graphics2D)graphics;
                g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
                g.drawImage(this.getImage(), x + (w - d.width) / 2, y + (h - d.height) / 2, d.width, d.height, null);
            }

            public int getIconWidth() {
                return w;
            }

            public int getIconHeight() {
                return h;
            }
        };
    }

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        Component c = super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
        if (c instanceof JLabel) {
            return this.decorateLabel((JLabel)c, value);
        }
        Log.warning("Component returned by DefaultTreeCellRenderer is not a JLabel, but a " + c.getClass());
        return c;
    }

    public JLabel decorateLabel(JLabel label, Object value) {
        Image image = this.getImageFor(value);
        if (image != null) {
            this.icon.setImage(image);
            label.setIcon(this.icon);
        } else {
            label.setIcon(null);
        }
        label.setText(this.getLabelFor(value));
        return label;
    }

    public abstract Image getImageFor(Object var1);

    public abstract String getLabelFor(Object var1);
}

