/*
 * Decompiled with CFR 0.152.
 */
package timon.common.components;

import java.awt.Component;
import javax.swing.AbstractCellEditor;
import javax.swing.JTable;
import javax.swing.table.TableCellEditor;

public class HTMLEscapeChars {
    public static char[] specialChars = new char[]{' ', '<', '>', '#', '%', '{', '}', '|', '^', '~', '[', ']', '`', ';', '/', '?', ':', '@', '=', '&', '$'};

    public static String escapeHTML(String string) {
        StringBuilder sb = new StringBuilder(string.length());
        int n = 0;
        while (n < string.length()) {
            boolean found = false;
            char c = string.charAt(n);
            int x = 0;
            while (x < specialChars.length) {
                if (c == specialChars[x]) {
                    sb.append("%" + Integer.toHexString(c));
                    found = true;
                    break;
                }
                ++x;
            }
            if (!found) {
                sb.append(c);
            }
            ++n;
        }
        return sb.toString();
    }

    public static String unescapeHTML(String raw) {
        StringBuilder sb = new StringBuilder(raw.length());
        int n = 0;
        while (n < raw.length()) {
            if (raw.charAt(n) == '%') {
                String hex = raw.substring(n + 1, n + 3);
                sb.append((char)Integer.parseInt(hex, 16));
                n += 2;
            } else {
                sb.append(raw.charAt(n));
            }
            ++n;
        }
        return sb.toString();
    }

    public static TableCellEditor getEscapingCellEditor(TableCellEditor editor) {
        return new WrappingTableCellEditor(editor);
    }

    private static class WrappingTableCellEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        private TableCellEditor editor;

        public WrappingTableCellEditor(TableCellEditor editor) {
            this.editor = editor;
        }

        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            return this.editor.getTableCellEditorComponent(table, value, isSelected, row, column);
        }

        public Object getCellEditorValue() {
            return HTMLEscapeChars.escapeHTML(String.valueOf(this.editor.getCellEditorValue()));
        }
    }
}

