/*
 * Decompiled with CFR 0.152.
 */
package timon.common.components;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.FontFormatException;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.io.File;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import timon.common.GraphicsUtil;
import timon.common.Log;
import timon.common.components.Skin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GuiUtil {
    public static final Color SELECTION_1 = new Color(129, 170, 231);
    public static final Color SELECTION_2 = new Color(56, 111, 199);
    public static final Color GRADIENT_1 = SELECTION_1;
    public static final Color GRADIENT_2 = new Color(104, 138, 186);
    public static final Color GRADIENT_3 = new Color(61, 93, 137);

    public static final Font loadFont(String name) {
        try {
            return Font.createFont(0, new File(name));
        }
        catch (FontFormatException e) {
            Log.warning(e);
        }
        catch (IOException e) {
            Log.warning(e);
        }
        return new Font("arial", 0, 12);
    }

    public static void recursiveSetEnabled(Component c, boolean e) {
        if (c instanceof Container) {
            Component[] componentArray = ((Container)c).getComponents();
            int n = componentArray.length;
            int n2 = 0;
            while (n2 < n) {
                Component child = componentArray[n2];
                child.setEnabled(e);
                GuiUtil.recursiveSetEnabled(child, e);
                ++n2;
            }
        }
    }

    public static void recursiveDisableRepaint(Component c, boolean b) {
        c.setIgnoreRepaint(b);
        if (c instanceof Container) {
            Component[] componentArray = ((Container)c).getComponents();
            int n = componentArray.length;
            int n2 = 0;
            while (n2 < n) {
                Component child = componentArray[n2];
                GuiUtil.recursiveDisableRepaint(child, b);
                ++n2;
            }
        }
    }

    public static TreePath getTreePathForObject(JTree tree, Object value) {
        List<Object> list = GuiUtil.getTreePathForObject(tree.getModel(), tree.getModel().getRoot(), value);
        if (list != null) {
            return new TreePath(list.toArray());
        }
        return null;
    }

    public static List<Object> getTreePathForObject(TreeModel model, Object nodeObject, Object value) {
        DefaultMutableTreeNode node;
        Object nodeValue;
        if (nodeObject instanceof DefaultMutableTreeNode && ((nodeValue = (node = (DefaultMutableTreeNode)nodeObject).getUserObject()) == value || nodeValue != null && nodeValue.equals(value))) {
            LinkedList<Object> list = new LinkedList<Object>();
            list.add(node);
            return list;
        }
        int n = 0;
        while (n < model.getChildCount(nodeObject)) {
            Object child = model.getChild(nodeObject, n);
            List<Object> list = GuiUtil.getTreePathForObject(model, child, value);
            if (list != null) {
                list.add(0, nodeObject);
                return list;
            }
            ++n;
        }
        return null;
    }

    public static void setSkin(String className) throws ClassNotFoundException, UnsupportedLookAndFeelException, InstantiationException, IllegalAccessException {
        GuiUtil.setSkin(new Skin(className));
    }

    public static void setSkin(Skin skin) throws ClassNotFoundException, UnsupportedLookAndFeelException, InstantiationException, IllegalAccessException {
        UIManager.setLookAndFeel(skin.getClassName());
    }

    public static void drawSelectionRect(Graphics g, int x, int y, int w, int h) {
        GuiUtil.drawSelectionRect(g, x, y, w, h, SELECTION_1, SELECTION_2);
    }

    public static void drawSelectionRect(Graphics g, int x, int y, int w, int h, Color c1, Color c2) {
        if (c1 != null) {
            g.setColor(c1);
            g.fillRect(x + 2, y + 2, w - 4, h - 4);
        }
        if (c2 != null) {
            g.setColor(c2);
            g.drawRect(x + 1, y + 1, w - 3, h - 3);
            g.drawLine(x + 1, y, x + w - 2, y);
            g.drawLine(x + 1, y + h - 1, x + w - 2, y + h - 1);
            g.drawLine(x, y + 1, x, y + h - 2);
            g.drawLine(x + w - 1, y + 1, x + w - 1, y + h - 2);
            g.setColor(GraphicsUtil.setAlpha(c2, 100));
            g.drawLine(x, y, x + 1, y + 1);
            g.drawLine(x + w - 1, y, x + w - 2, y + 1);
            g.drawLine(x, y + h - 1, x + 1, y + h - 2);
            g.drawLine(x + w - 1, y + h - 1, x + w - 2, y + h - 2);
        }
    }

    public static void drawGradientSelectionRect(Graphics graphics, int x, int y, int w, int h) {
        Graphics2D g = (Graphics2D)graphics;
        g.setColor(GRADIENT_3);
        g.drawRect(x + 1, y + 1, w - 3, h - 3);
        g.drawLine(x + 1, y, x + w - 2, y);
        g.drawLine(x + 1, y + h - 1, x + w - 2, y + h - 1);
        g.drawLine(x, y + 1, x, y + h - 2);
        g.drawLine(x + w - 1, y + 1, x + w - 1, y + h - 2);
        GradientPaint gradient = new GradientPaint(2.0f, 2.0f, GRADIENT_1, 2.0f, 2 + h, GRADIENT_2);
        g.setPaint(gradient);
        g.fillRect(2, 2, w - 4, h - 4);
    }
}

