/*
 * Decompiled with CFR 0.152.
 */
package timon.common.components;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.BevelBorder;
import timon.common.GraphicsUtil;
import timon.common.collections.GraphNode;
import timon.common.components.GuiUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class GraphPanel<E>
extends JPanel {
    private Image arrowHeadI;
    private List<NodeButton> nodeButtons;
    private List<List<GraphNode<E>>> scenesPerDist;
    private List<ActionListener> listeners;
    private List<ActionListener> nodeClickListeners;
    private GraphNode<E> root;
    private GraphNode<E> selected;

    public GraphPanel(Image arrowHeadImage) {
        this.arrowHeadI = arrowHeadImage;
        this.nodeButtons = new ArrayList<NodeButton>();
        this.listeners = new ArrayList<ActionListener>();
        this.nodeClickListeners = new ArrayList<ActionListener>();
        JScrollPane contentPane = new JScrollPane(new Content());
        contentPane.setBorder(new BevelBorder(1));
        contentPane.setPreferredSize(new Dimension(200, 350));
        this.setLayout(new BorderLayout());
        this.add((Component)contentPane, "Center");
    }

    public void update() {
        this.nodeButtons.clear();
        if (this.root != null) {
            boolean done;
            Collection<GraphNode<E>> nodes = this.collectNodes();
            HashMap<GraphNode<E>, Integer> dist = new HashMap<GraphNode<E>, Integer>();
            this.calculateDists(dist, this.root, 0);
            block0: do {
                int maxDist = (Integer)Collections.max(dist.values());
                done = true;
                for (GraphNode<E> node : nodes) {
                    if (dist.get(node) != null) continue;
                    this.calculateDists(dist, node, maxDist + 1);
                    done = false;
                    continue block0;
                }
            } while (!done);
            this.scenesPerDist = new ArrayList<List<GraphNode<E>>>();
            int n = 0;
            while (n <= (Integer)Collections.max(dist.values())) {
                this.scenesPerDist.add(new ArrayList());
                ++n;
            }
            for (GraphNode<E> node : nodes) {
                int d = (Integer)dist.get(node);
                this.nodeButtons.add(new NodeButton(node, d));
                this.scenesPerDist.get(d).add(node);
            }
        }
        this.repaint();
    }

    protected void calculateDists(Map<GraphNode<E>, Integer> distMap, GraphNode<E> current, int dist) {
        if (current == null) {
            return;
        }
        Integer i = distMap.get(current);
        if (i != null && i <= dist) {
            return;
        }
        distMap.put(current, dist);
        ++dist;
        for (GraphNode<E> node : current.getOutgoingConnections()) {
            this.calculateDists(distMap, node, dist);
        }
    }

    protected Collection<GraphNode<E>> collectNodes() {
        if (this.root == null) {
            return Collections.emptyList();
        }
        return this.root.findAll();
    }

    protected void accumulateInlinks(GraphNode<E> node, List<GraphNode<E>> list) {
        for (GraphNode<E> n : node.getIncomingConnections()) {
            list.add(n);
        }
    }

    protected void accumulateOutlinks(GraphNode<E> node, List<GraphNode<E>> list) {
        for (GraphNode<E> n : node.getOutgoingConnections()) {
            list.add(n);
        }
    }

    private void onNodeClicked(GraphNode<E> node, MouseEvent event) {
        if (event.getButton() == 1 && event.getClickCount() >= 2) {
            ActionEvent actionEvent = new ActionEvent(node, 0, "clicked");
            for (ActionListener al : this.nodeClickListeners) {
                al.actionPerformed(actionEvent);
            }
        }
    }

    public void addListener(ActionListener al) {
        this.listeners.add(al);
    }

    public void removeListener(ActionListener al) {
        this.listeners.remove(al);
    }

    public void notifyListeners() {
        ActionEvent event = new ActionEvent(this, 0, "selection");
        for (ActionListener al : this.listeners) {
            al.actionPerformed(event);
        }
    }

    public void addNodeClickListener(ActionListener ml) {
        this.nodeClickListeners.add(ml);
    }

    public void removeNodeClickListener(ActionListener ml) {
        this.nodeClickListeners.remove(ml);
    }

    protected abstract Icon getIconFor(GraphNode<E> var1, boolean var2);

    protected NodeButton getButtonFor(GraphNode<E> node) {
        for (NodeButton button : this.nodeButtons) {
            if (button.getNode() != node) continue;
            return button;
        }
        return null;
    }

    public GraphNode<E> getSelectedNode() {
        return this.selected;
    }

    public GraphNode<E> getRoot() {
        return this.root;
    }

    protected boolean isNodeEnabled(GraphNode<E> node) {
        return true;
    }

    public void setSelectedNode(GraphNode<E> node) {
        if (this.selected != node) {
            this.selected = node;
            this.update();
            this.notifyListeners();
        }
    }

    public void setRoot(GraphNode<E> root) {
        this.root = root;
    }

    private class Content
    extends JPanel {
        public Content() {
            this.setBackground(new Color(220, 220, 220));
            this.addMouseListener(new MouseAdapter(){

                public void mousePressed(MouseEvent event) {
                    for (NodeButton b : GraphPanel.this.nodeButtons) {
                        if (!GraphPanel.this.isNodeEnabled(b.getNode()) || !b.getBounds().contains(event.getPoint())) continue;
                        GraphPanel.this.setSelectedNode(b.getNode());
                        break;
                    }
                }

                public void mouseClicked(MouseEvent event) {
                    for (NodeButton b : GraphPanel.this.nodeButtons) {
                        if (!GraphPanel.this.isNodeEnabled(b.getNode()) || !b.getBounds().contains(event.getPoint())) continue;
                        GraphPanel.this.onNodeClicked(b.getNode(), event);
                        break;
                    }
                }
            });
        }

        protected void paintComponent(Graphics graphics) {
            int y;
            Graphics2D g = (Graphics2D)graphics;
            int w = this.getWidth();
            int h = this.getHeight();
            int pad = 10;
            int s = 48;
            g.setBackground(this.getBackground());
            g.clearRect(0, 0, w, h);
            int maxDist = 0;
            for (NodeButton button : GraphPanel.this.nodeButtons) {
                GraphNode node = button.getNode();
                maxDist = Math.max(maxDist, button.getDist());
                List list = (List)GraphPanel.this.scenesPerDist.get(button.getDist());
                float a = (float)(w - pad * 2) / (float)list.size();
                int b = Math.round((float)list.indexOf(node) * a);
                int x = pad + b + Math.round((a - (float)s) * 0.5f);
                y = button.getDist() * (s + pad) + pad;
                button.paint(g, x, y, s, s);
            }
            y = (maxDist + 1) * (s + pad) + pad;
            NodeButton selectedButton = GraphPanel.this.getButtonFor(GraphPanel.this.selected);
            for (NodeButton button : GraphPanel.this.nodeButtons) {
                if (button == selectedButton) continue;
                button.paintConnections(g, false);
            }
            if (selectedButton != null) {
                selectedButton.paintConnections(g, true);
            }
            if (y != h) {
                this.setPreferredSize(new Dimension(1, y));
                this.revalidate();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class NodeButton {
        private GraphNode<E> node;
        private List<GraphNode<E>> aggregateIncoming;
        private List<GraphNode<E>> aggregateOutgoing;
        private int dist;
        private Rectangle bounds;

        public NodeButton(GraphNode<E> node, int dist) {
            this.node = node;
            this.aggregateIncoming = new ArrayList();
            this.aggregateOutgoing = new ArrayList();
            this.dist = dist;
            this.bounds = new Rectangle(-1, -1, 0, 0);
            GraphPanel.this.accumulateInlinks(node, this.aggregateIncoming);
            GraphPanel.this.accumulateOutlinks(node, this.aggregateOutgoing);
        }

        public void paint(Graphics g, int x, int y, int w, int h) {
            Icon icon;
            this.bounds.x = x;
            this.bounds.y = y;
            this.bounds.width = w;
            this.bounds.height = h;
            g.translate(x, y);
            int size = Math.min(w, h);
            if (GraphPanel.this.selected == this.node) {
                GuiUtil.drawSelectionRect(g, 0, 0, size, size);
            }
            if ((icon = GraphPanel.this.getIconFor(this.node, !GraphPanel.this.isNodeEnabled(this.node))) != null) {
                icon.paintIcon(GraphPanel.this, g, 0, 0);
            }
            g.translate(-x, -y);
        }

        public void paintConnections(Graphics2D g, boolean selected) {
            NodeButton button;
            g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
            Point center = this.getCenter();
            for (GraphNode node : this.aggregateIncoming) {
                button = GraphPanel.this.getButtonFor(node);
                if (button == null) continue;
                this.drawConnector(g, button.getCenter(), center, selected);
            }
            for (GraphNode node : this.aggregateOutgoing) {
                button = GraphPanel.this.getButtonFor(node);
                if (button == null) continue;
                this.drawConnector(g, center, button.getCenter(), selected);
            }
        }

        protected void drawConnector(Graphics2D g, Point p1, Point p2, boolean selected) {
            p1 = new Point(p1);
            p2 = new Point(p2);
            int deltaX = p1.x - p2.x;
            int deltaY = p1.y - p2.y;
            p2.x = (int)((double)p2.x + Math.min(20.0, Math.max(-20.0, (double)deltaX * 0.25)));
            p2.y = (int)((double)p2.y + Math.min(20.0, Math.max(-20.0, (double)deltaY * 0.25)));
            p1.x = (int)((double)p1.x - Math.min(20.0, Math.max(-20.0, (double)deltaX * 0.25)));
            p1.y = (int)((double)p1.y - Math.min(20.0, Math.max(-20.0, (double)deltaY * 0.25)));
            Composite oldComposite = g.getComposite();
            if (!selected) {
                g.setComposite(AlphaComposite.getInstance(3, 0.25f));
            } else {
                g.setComposite(AlphaComposite.getInstance(3, 0.85f));
            }
            if (selected) {
                AffineTransform oldTransform = g.getTransform();
                g.translate(p2.x, p2.y);
                g.rotate(1.5707963267948966 + Math.atan2(p2.y - p1.y, p2.x - p1.x));
                int iw = GraphPanel.this.arrowHeadI.getWidth(null);
                int ih = GraphPanel.this.arrowHeadI.getHeight(null);
                Dimension d = GraphicsUtil.getProportionalScale(iw, ih, 20, 20);
                iw = d.width;
                ih = d.height;
                g.drawImage(GraphPanel.this.arrowHeadI, -iw / 2, -ih / 2, iw, ih, GraphPanel.this);
                g.setTransform(oldTransform);
            }
            g.setColor(new Color(0, 0, 0, 50));
            g.setStroke(new BasicStroke(2.0f));
            g.drawLine(p1.x, p1.y, p2.x, p2.y);
            g.setColor(Color.WHITE);
            g.setStroke(new BasicStroke(1.5f));
            g.drawLine(p1.x, p1.y, p2.x, p2.y);
            g.setComposite(oldComposite);
        }

        public GraphNode<E> getNode() {
            return this.node;
        }

        public int getDist() {
            return this.dist;
        }

        public Rectangle getBounds() {
            return this.bounds;
        }

        public Point getCenter() {
            return new Point(this.bounds.x + this.bounds.width / 2, this.bounds.y + this.bounds.height / 2);
        }
    }
}

