/*
 * Decompiled with CFR 0.152.
 */
package timon.common.components;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.GridLayout;
import java.awt.Rectangle;
import java.util.Arrays;
import javax.swing.AbstractListModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListModel;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import timon.common.Log;
import timon.common.components.DirectTextField;
import timon.common.components.StringSortedListModel;
import timon.common.components.TextChangeListener;
import timon.common.internal.Text;

public class FontChooser
extends JPanel {
    private static final String PREFIX = "components.FontChooser.";
    protected static boolean defaultsInited;
    protected static String[] fontFamilies;
    protected static int[] fontStyles;
    protected static int[] defaultSizes;
    private FieldList familyList;
    private FieldList styleList;
    private FieldList sizeList;
    private PreviewPanel previewPanel;

    public FontChooser() {
        if (!defaultsInited) {
            this.initDefaults();
            defaultsInited = true;
        }
        this.createGUI();
    }

    protected void initDefaults() {
        fontFamilies = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
        Arrays.sort(fontFamilies, StringSortedListModel.createComparator());
        int[] nArray = new int[4];
        nArray[1] = 1;
        nArray[2] = 2;
        nArray[3] = 3;
        fontStyles = nArray;
        defaultSizes = new int[]{6, 8, 10, 11, 12, 14, 16, 18, 20, 22, 24, 26, 28, 32, 40, 48, 56, 64, 72};
    }

    protected void createGUI() {
        this.familyList = new FieldList(Text.get("components.FontChooser.familyLabel")){

            public Object getValue() {
                return this.list.getSelectedValue();
            }
        };
        this.familyList.setListModel(new AbstractListModel(){

            public Object getElementAt(int index) {
                return fontFamilies[index];
            }

            public int getSize() {
                return fontFamilies.length;
            }
        });
        this.styleList = new FieldList(Text.get("components.FontChooser.styleLabel")){

            protected void updateFieldFromListSelection(Object value) {
                super.updateFieldFromListSelection(this.labelFor(value));
            }

            protected Object labelFor(Object value) {
                int i = (Integer)value;
                if (i == 0) {
                    return Text.get("components.FontChooser.style.plain");
                }
                if (i == 1) {
                    return Text.get("components.FontChooser.style.bold");
                }
                if (i == 2) {
                    return Text.get("components.FontChooser.style.italic");
                }
                if (i == 3) {
                    return Text.get("components.FontChooser.style.boldItalic");
                }
                return "<ERROR>";
            }

            public Object getValue() {
                return this.list.getSelectedValue();
            }
        };
        this.styleList.setListModel(new AbstractListModel(){

            public Object getElementAt(int index) {
                return fontStyles[index];
            }

            public int getSize() {
                return fontStyles.length;
            }
        });
        this.sizeList = new FieldList(Text.get("components.FontChooser.sizeLabel")){

            protected void selectCorrespondingInList(String text) {
                int n = 0;
                while (n < this.list.getModel().getSize()) {
                    Object object = this.list.getModel().getElementAt(n);
                    if (text.equals(String.valueOf(object))) {
                        this.list.setSelectedValue(object, true);
                        return;
                    }
                    ++n;
                }
                this.list.clearSelection();
            }
        };
        this.sizeList.setListModel(new AbstractListModel(){

            public Object getElementAt(int index) {
                return defaultSizes[index];
            }

            public int getSize() {
                return defaultSizes.length;
            }
        });
        JPanel centerPanel = new JPanel(new BorderLayout(5, 5));
        centerPanel.setLayout(new GridLayout(1, 3, 5, 5));
        centerPanel.add(this.familyList);
        centerPanel.add(this.styleList);
        centerPanel.add(this.sizeList);
        this.previewPanel = new PreviewPanel();
        this.setLayout(new BorderLayout(5, 5));
        this.add((Component)centerPanel, "Center");
        this.add((Component)this.previewPanel, "South");
        this.setPreferredSize(new Dimension(425, 350));
    }

    protected void fontChanged() {
        this.previewPanel.setSelectedFont(this.getSelectedFont());
    }

    public Font getSelectedFont() {
        if (this.familyList.getValue() == null || this.styleList.getValue() == null || this.sizeList.getValue() == null) {
            return null;
        }
        String family = String.valueOf(this.familyList.getValue());
        String style = String.valueOf(this.styleList.getValue());
        String size = String.valueOf(this.sizeList.getValue());
        try {
            return new Font(family, Integer.parseInt(style), Integer.parseInt(size));
        }
        catch (NumberFormatException nfe) {
            Log.warning(nfe);
            return null;
        }
    }

    public void setSelectedFont(Font font) {
        if (font != null) {
            this.familyList.setSelectedValue(font.getFamily(), true);
            this.styleList.setSelectedValue(font.getStyle(), true);
            this.sizeList.setSelectedValue(font.getSize(), true);
        } else {
            this.familyList.setSelectedValue(null, true);
            this.styleList.setSelectedValue(null, true);
            this.sizeList.setSelectedValue(null, true);
        }
        this.fontChanged();
    }

    private class FieldList
    extends JPanel {
        protected DirectTextField field;
        protected JList list;
        private int disableSelectionListeners;
        private boolean fieldPreference;

        public FieldList(String label) {
            JLabel topLabel = new JLabel(label);
            this.field = this.createField();
            this.list = this.createList();
            this.field.addTextChangeListener(new TextChangeListener(){

                public void textChanged(Object source, String newText) {
                    if (FieldList.this.disableSelectionListeners == 0) {
                        FieldList fieldList = FieldList.this;
                        fieldList.disableSelectionListeners = fieldList.disableSelectionListeners + 1;
                        FieldList.this.fieldPreference = true;
                        FieldList.this.selectCorrespondingInList(newText);
                        FontChooser.this.fontChanged();
                        FieldList fieldList2 = FieldList.this;
                        fieldList2.disableSelectionListeners = fieldList2.disableSelectionListeners - 1;
                    }
                }
            });
            this.list.addListSelectionListener(new ListSelectionListener(){

                public void valueChanged(ListSelectionEvent e) {
                    if (FieldList.this.disableSelectionListeners == 0) {
                        FieldList fieldList = FieldList.this;
                        fieldList.disableSelectionListeners = fieldList.disableSelectionListeners + 1;
                        FieldList.this.fieldPreference = false;
                        FieldList.this.updateFieldFromListSelection(FieldList.this.list.getSelectedValue());
                        FontChooser.this.fontChanged();
                        FieldList fieldList2 = FieldList.this;
                        fieldList2.disableSelectionListeners = fieldList2.disableSelectionListeners - 1;
                    }
                }
            });
            JPanel topPanel = new JPanel(new GridLayout(-1, 1, 5, 5));
            topPanel.add(topLabel);
            topPanel.add(this.field);
            this.setLayout(new BorderLayout(5, 5));
            this.add((Component)topPanel, "North");
            this.add((Component)new JScrollPane(this.list), "Center");
        }

        protected DirectTextField createField() {
            DirectTextField field = new DirectTextField();
            return field;
        }

        protected JList createList() {
            JList<Object> list = new JList<Object>();
            list.setSelectionMode(0);
            list.setCellRenderer(new DefaultListCellRenderer(){

                public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                    return super.getListCellRendererComponent((JList<?>)list, FieldList.this.labelFor(value), index, isSelected, cellHasFocus);
                }
            });
            return list;
        }

        protected void selectCorrespondingInList(String text) {
            int bestRow = -1;
            int bestValue = 0;
            int n = 0;
            while (n < this.list.getModel().getSize()) {
                Object object = this.list.getModel().getElementAt(n);
                int match = this.match(text, String.valueOf(this.labelFor(object)));
                if (match > bestValue) {
                    bestRow = n;
                    bestValue = match;
                }
                ++n;
            }
            if (bestRow >= 0) {
                this.list.setSelectedIndex(bestRow);
                Rectangle cellBounds = this.list.getCellBounds(bestRow, bestRow);
                if (cellBounds != null) {
                    this.list.scrollRectToVisible(cellBounds);
                }
            } else {
                this.list.clearSelection();
            }
        }

        protected void updateFieldFromListSelection(Object object) {
            this.field.setText("" + object);
        }

        protected int match(String prefix, String text) {
            int n = 0;
            n = 0;
            while (n < Math.min(prefix.length(), text.length())) {
                if (Character.toLowerCase(prefix.charAt(n)) != Character.toLowerCase(text.charAt(n))) {
                    return n - 1;
                }
                ++n;
            }
            return n;
        }

        protected Object labelFor(Object value) {
            return value;
        }

        public Object getValue() {
            if (this.fieldPreference) {
                return this.field.getText().trim();
            }
            return this.list.getSelectedValue();
        }

        public void setListModel(ListModel model) {
            this.list.setModel(model);
        }

        public void setSelectedValue(Object value, boolean autoscroll) {
            this.list.setSelectedValue(value, autoscroll);
        }
    }

    private class PreviewPanel
    extends JPanel {
        private JLabel label = new JLabel("abcABC123");

        public PreviewPanel() {
            this.label.setHorizontalAlignment(0);
            this.label.setVerticalAlignment(0);
            this.setBorder(new TitledBorder(Text.get("components.FontChooser.previewLabel")));
            this.setLayout(new BorderLayout());
            this.add((Component)this.label, "Center");
            this.setPreferredSize(new Dimension(100, 100));
        }

        public void setSelectedFont(Font font) {
            if (font != null) {
                this.label.setFont(font);
            }
        }
    }
}

