/*
 * Decompiled with CFR 0.152.
 */
package timon.common.components;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import timon.common.components.BrowseField;
import timon.common.components.DirectoryChooser;
import timon.common.components.GuiUtil;

public class FileBrowseField
extends JPanel {
    private List<ActionListener> listeners;
    private JLabel label;
    private BrowseField browseField;

    public FileBrowseField(String labelText, String path) {
        this.label = new JLabel(labelText);
        this.listeners = new LinkedList<ActionListener>();
        JTextField textField = new JTextField();
        textField.setEditable(false);
        this.browseField = new BrowseField(textField);
        this.browseField.setText(path);
        this.browseField.getButton().addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DirectoryChooser chooser = new DirectoryChooser();
                if (chooser.showDialog(FileBrowseField.this, "Choose a folder") && chooser.getSelectedDirectory() != null) {
                    FileBrowseField.this.browseField.setText(chooser.getSelectedDirectory().getAbsolutePath());
                    FileBrowseField.this.fireAction();
                }
            }
        });
        this.setLayout(new BorderLayout(5, 5));
        this.add((Component)this.label, "West");
        this.add((Component)this.browseField, "Center");
    }

    public void addActionListener(ActionListener al) {
        this.listeners.add(al);
    }

    protected void fireAction() {
        ActionEvent event = new ActionEvent(this.browseField, 0, "selected");
        for (ActionListener al : this.listeners) {
            al.actionPerformed(event);
        }
    }

    public String getSelectedPath() {
        return this.browseField.getText();
    }

    public void setEnabled(boolean e) {
        GuiUtil.recursiveSetEnabled(this, e);
    }

    public void setOpaque(boolean o) {
        super.setOpaque(o);
        if (this.label != null) {
            this.label.setOpaque(o);
        }
        if (this.browseField != null) {
            this.browseField.setOpaque(o);
        }
    }
}

