/*
 * Decompiled with CFR 0.152.
 */
package timon.common.components;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.FlavorEvent;
import java.awt.datatransfer.FlavorListener;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import timon.common.Log;
import timon.common.components.IconLoader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class EditableList<V>
extends JPanel
implements ClipboardOwner {
    private boolean isCutAllowed;
    private boolean isCopyAllowed;
    private boolean isPasteAllowed;
    private boolean isDeleteAllowed;
    private boolean isMoveAllowed;
    private boolean isAddItemAllowed;
    protected final boolean layoutVertical;
    protected JComponent buttonPanel;
    protected JButton cutButton;
    protected JButton copyButton;
    protected JButton pasteButton;
    protected JButton moveUpButton;
    protected JButton moveDownButton;
    protected JButton addItemButton;
    protected JButton removeItemButton;

    public EditableList(boolean vertical) {
        this.layoutVertical = vertical;
        this.isCutAllowed = true;
        this.isCopyAllowed = true;
        this.isPasteAllowed = true;
        this.isMoveAllowed = false;
        this.isAddItemAllowed = true;
        this.isDeleteAllowed = true;
        this.getToolkit().getSystemClipboard().addFlavorListener(new FlavorListener(){

            public void flavorsChanged(FlavorEvent e) {
                EditableList.this.updatePasteButton();
            }
        });
        this.buttonPanel = this.createButtonPanel(vertical);
    }

    protected void addComponents(boolean vertical) {
        this.setLayout(new BorderLayout(2, 2));
        this.add((Component)new JScrollPane(this.getList()), "Center");
        this.add((Component)this.buttonPanel, vertical ? "East" : "South");
    }

    protected JPanel createButtonPanel(boolean vertical) {
        return this.createButtonPanel(vertical ? 1 : 0);
    }

    protected JPanel createButtonPanel(int boxLayoutDirection) {
        Component item;
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, boxLayoutDirection));
        int t = 0;
        do {
            if ((item = this.createButtonPanelItem(t)) != null) {
                if (item instanceof AbstractButton) {
                    item.setPreferredSize(new Dimension(20, 20));
                }
                panel.add(item);
            }
            ++t;
        } while (item != null);
        JPanel panel2 = new JPanel(new BorderLayout());
        panel2.add((Component)panel, "North");
        return panel2;
    }

    protected Component createButtonPanelItem(int index) {
        if (index == 0) {
            return Box.createRigidArea(new Dimension(1, 1));
        }
        if (index == 1) {
            this.cutButton = new JButton(IconLoader.getIcon("img/cut.png"));
            this.cutButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    EditableList.this.cut();
                }
            });
            return this.cutButton;
        }
        if (index == 2) {
            this.copyButton = new JButton(IconLoader.getIcon("img/copy.png"));
            this.copyButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    EditableList.this.copy();
                }
            });
            return this.copyButton;
        }
        if (index == 3) {
            this.pasteButton = new JButton(IconLoader.getIcon("img/paste.png"));
            this.pasteButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    EditableList.this.paste();
                }
            });
            return this.pasteButton;
        }
        if (index == 4) {
            return this.createButtonPanelSpacer(index);
        }
        if (index == 5) {
            this.moveUpButton = new JButton(IconLoader.getIcon("img/moveItemUp.png"));
            this.moveUpButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    EditableList.this.moveItemUp();
                }
            });
            return this.moveUpButton;
        }
        if (index == 6) {
            this.moveDownButton = new JButton(IconLoader.getIcon("img/moveItemDown.png"));
            this.moveDownButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    EditableList.this.moveItemDown();
                }
            });
            return this.moveDownButton;
        }
        if (index == 7) {
            return this.createButtonPanelSpacer(index);
        }
        if (index == 8) {
            this.addItemButton = new JButton(IconLoader.getIcon("img/addItem.png"));
            this.addItemButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    EditableList.this.addItem();
                }
            });
            return this.addItemButton;
        }
        if (index == 9) {
            this.removeItemButton = new JButton(IconLoader.getIcon("img/removeItem.png"));
            this.removeItemButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    EditableList.this.delete();
                }
            });
            return this.removeItemButton;
        }
        return null;
    }

    protected Component createButtonPanelSpacer(int index) {
        return Box.createRigidArea(new Dimension(10, 10));
    }

    protected abstract void addItem();

    protected void cut() {
        this.copy();
        this.delete();
    }

    protected abstract void copy();

    protected abstract void paste();

    protected abstract void delete();

    protected abstract void moveItem(int var1);

    protected abstract boolean supportsDataFlavor(DataFlavor var1);

    public abstract void addListSelectionListener(ListSelectionListener var1);

    public abstract void removeListSelectionListener(ListSelectionListener var1);

    protected final void moveItemUp() {
        this.moveItem(-1);
    }

    protected final void moveItemDown() {
        this.moveItem(1);
    }

    protected void copyTranferable(Transferable transferable) {
        this.getToolkit().getSystemClipboard().setContents(transferable, this);
    }

    protected void updateButtons() {
        boolean e = this.isEnabled();
        V value = this.getSelectedValue();
        this.cutButton.setEnabled(e && this.isCutAllowed() && value != null);
        this.copyButton.setEnabled(e && this.isCopyAllowed() && value != null);
        this.updatePasteButton();
        this.moveUpButton.setEnabled(e && this.isMoveAllowed() && value != null);
        this.moveDownButton.setEnabled(e && this.isMoveAllowed() && value != null);
        this.moveUpButton.setVisible(this.isMoveAllowed());
        this.moveDownButton.setVisible(this.isMoveAllowed());
        this.addItemButton.setEnabled(e && this.isAddItemAllowed());
        this.removeItemButton.setEnabled(e && this.isDeleteAllowed() && value != null);
        this.addItemButton.setVisible(this.isAddItemAllowed() || this.isDeleteAllowed());
        this.removeItemButton.setVisible(this.isAddItemAllowed() || this.isDeleteAllowed());
        this.buttonPanel.validate();
    }

    protected void updatePasteButton() {
        this.pasteButton.setEnabled(this.isEnabled() && this.isPasteAllowed() && this.getTranferable() != null);
        this.pasteButton.setVisible(this.isPasteAllowed());
    }

    @Override
    public void lostOwnership(Clipboard clipboard, Transferable contents) {
    }

    protected abstract JComponent getList();

    public abstract V getSelectedValue();

    protected Object getTranferable() {
        DataFlavor[] dataFlavorArray = this.getToolkit().getSystemClipboard().getAvailableDataFlavors();
        int n = dataFlavorArray.length;
        int n2 = 0;
        while (n2 < n) {
            DataFlavor df = dataFlavorArray[n2];
            if (this.supportsDataFlavor(df)) {
                try {
                    return this.getToolkit().getSystemClipboard().getData(df);
                }
                catch (Exception e) {
                    Log.warning(e);
                }
            }
            ++n2;
        }
        return null;
    }

    public boolean isAddItemAllowed() {
        return this.isAddItemAllowed;
    }

    public boolean isCopyAllowed() {
        return this.isCopyAllowed;
    }

    public boolean isCutAllowed() {
        return this.isCutAllowed;
    }

    public boolean isDeleteAllowed() {
        return this.isDeleteAllowed;
    }

    public boolean isMoveAllowed() {
        return this.isMoveAllowed;
    }

    public boolean isPasteAllowed() {
        return this.isPasteAllowed;
    }

    public abstract void setSelectedValue(V var1, boolean var2);

    @Override
    public void setEnabled(boolean e) {
        super.setEnabled(e);
        this.updateButtons();
    }

    public void setList(Object list) {
        this.addComponents(this.layoutVertical);
        this.updateButtons();
        this.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                EditableList.this.updateButtons();
            }
        });
    }

    public void setAddItemAllowed(boolean isAddItemAllowed) {
        this.isAddItemAllowed = isAddItemAllowed;
        this.updateButtons();
    }

    public void setCopyAllowed(boolean isCopyAllowed) {
        this.isCopyAllowed = isCopyAllowed;
        this.updateButtons();
    }

    public void setCutAllowed(boolean isCutAllowed) {
        this.isCutAllowed = isCutAllowed;
        this.updateButtons();
    }

    public void setDeleteAllowed(boolean isDeleteAllowed) {
        this.isDeleteAllowed = isDeleteAllowed;
        this.updateButtons();
    }

    public void setMoveAllowed(boolean isMoveAllowed) {
        this.isMoveAllowed = isMoveAllowed;
        this.updateButtons();
    }

    public void setPasteAllowed(boolean isPasteAllowed) {
        this.isPasteAllowed = isPasteAllowed;
        this.updateButtons();
    }
}

