/*
 * Decompiled with CFR 0.152.
 */
package timon.common.components;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.io.File;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.filechooser.FileSystemView;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public class DirectoryChooser
extends JPanel {
    private FileSystemView fileSystemView = FileSystemView.getFileSystemView();
    private FileNodeSorter fileNodeSorter = new FileNodeSorter();
    private JTree tree = new JTree();

    public DirectoryChooser() {
        this.tree.setModel(new DirectoryTreeModel());
        this.tree.setCellRenderer(new DirectoryCellRenderer());
        this.tree.setRootVisible(false);
        this.tree.setShowsRootHandles(true);
        this.setPreferredSize(new Dimension(250, 350));
        this.setLayout(new BorderLayout());
        this.add((Component)new JScrollPane(this.tree), "Center");
    }

    public static void main(String[] args) {
        DirectoryChooser dc = new DirectoryChooser();
        dc.showDialog(null, "");
    }

    public boolean showDialog(Component parentComponent, String title) {
        return JOptionPane.showConfirmDialog(parentComponent, this, title, 2, -1) == 0;
    }

    public File getSelectedDirectory() {
        Object object;
        TreePath path = this.tree.getSelectionPath();
        if (path != null && path.getPathCount() > 0 && (object = path.getLastPathComponent()) instanceof FileNode) {
            return ((FileNode)object).getFile();
        }
        return null;
    }

    private class DirectoryCellRenderer
    extends DefaultTreeCellRenderer {
        private DirectoryCellRenderer() {
        }

        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            Component c = super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
            if (c instanceof JLabel) {
                JLabel label = (JLabel)c;
                if (value instanceof FileNode) {
                    FileNode file = (FileNode)value;
                    label.setText(file.getLabel());
                    label.setIcon(file.getIcon());
                }
            }
            return c;
        }
    }

    private class DirectoryTreeModel
    implements TreeModel {
        private RootFile rootFile;
        private List<TreeModelListener> listeners;

        public DirectoryTreeModel() {
            this.rootFile = new RootFile();
            this.listeners = new ArrayList<TreeModelListener>();
        }

        public void addTreeModelListener(TreeModelListener l) {
            this.listeners.add(l);
        }

        public void removeTreeModelListener(TreeModelListener l) {
            this.listeners.remove(l);
        }

        public void valueForPathChanged(TreePath path, Object newValue) {
            TreeModelListener[] tmls;
            TreeModelEvent event = new TreeModelEvent((Object)this, path);
            TreeModelListener[] treeModelListenerArray = tmls = this.listeners.toArray(new TreeModelListener[0]);
            int n = tmls.length;
            int n2 = 0;
            while (n2 < n) {
                TreeModelListener tml = treeModelListenerArray[n2];
                tml.treeNodesChanged(event);
                ++n2;
            }
        }

        protected FileNode toFileNode(Object obj) {
            return obj instanceof FileNode ? (FileNode)obj : null;
        }

        public Object getChild(Object parent, int index) {
            FileNode f = this.toFileNode(parent);
            if (f != null) {
                return f.getChild(index);
            }
            return null;
        }

        public int getChildCount(Object parent) {
            FileNode f = this.toFileNode(parent);
            if (f != null) {
                return f.getChildCount();
            }
            return 0;
        }

        public int getIndexOfChild(Object parent, Object child) {
            FileNode f = this.toFileNode(parent);
            if (f != null) {
                return f.getChildIndex(child);
            }
            return -1;
        }

        public Object getRoot() {
            return this.rootFile;
        }

        public boolean isLeaf(Object node) {
            return this.getChildCount(node) <= 0;
        }
    }

    private class FileNode {
        private File file;
        protected List<FileNode> children;

        public FileNode(File file) {
            this.file = file;
        }

        protected void initChildren() {
            this.children = new ArrayList<FileNode>();
            File[] files = this.file.listFiles();
            if (files != null) {
                File[] fileArray = files;
                int n = files.length;
                int n2 = 0;
                while (n2 < n) {
                    File f = fileArray[n2];
                    if (f.isDirectory() && !f.isHidden()) {
                        this.children.add(new FileNode(f));
                    }
                    ++n2;
                }
            }
            Collections.sort(this.children, DirectoryChooser.this.fileNodeSorter);
        }

        public int getChildCount() {
            if (this.children == null) {
                this.initChildren();
            }
            return this.children.size();
        }

        public Object getChild(int index) {
            if (this.children == null) {
                this.initChildren();
            }
            return index >= 0 && index < this.children.size() ? this.children.get(index) : null;
        }

        public int getChildIndex(Object child) {
            if (this.children == null) {
                this.initChildren();
            }
            return this.children.indexOf(child);
        }

        public File getFile() {
            return this.file;
        }

        public String getLabel() {
            if (this.file == null) {
                return "";
            }
            String text = DirectoryChooser.this.fileSystemView.getSystemDisplayName(this.file);
            if (text == null || text.length() <= 0) {
                text = this.file.getAbsolutePath();
            }
            return text;
        }

        public Icon getIcon() {
            if (this.file == null) {
                return null;
            }
            return DirectoryChooser.this.fileSystemView.getSystemIcon(this.file);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class FileNodeSorter
    implements Comparator<FileNode> {
        private Collator sorter = Collator.getInstance();

        private FileNodeSorter() {
        }

        @Override
        public int compare(FileNode fn1, FileNode fn2) {
            if (fn1 == null) {
                return fn2 != null ? 1 : 0;
            }
            return fn2 == null ? -1 : this.sorter.compare(fn1.getLabel(), fn2.getLabel());
        }
    }

    private class RootFile
    extends FileNode {
        public RootFile() {
            super(null);
        }

        protected void initChildren() {
            this.children = new ArrayList();
            File[] fileArray = File.listRoots();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File f = fileArray[n2];
                this.children.add(new FileNode(f));
                ++n2;
            }
        }
    }
}

