/*
 * Decompiled with CFR 0.152.
 */
package timon.common.components;

import java.awt.Color;
import timon.common.components.DirectTextField;
import timon.common.components.TextChangeListener;

public abstract class DirectValidationField
extends DirectTextField {
    private String lastText;
    private Color defaultForeground;
    private Color defaultBackground;
    private Color errorForegroundEnabled;
    private Color errorForegroundDisabled;
    private Color errorBackgroundEnabled;
    private Color errorBackgroundDisabled;

    public DirectValidationField() {
        this.initDefaultColors();
        this.addTextChangeListener(new TextChangeListener(){

            public void textChanged(Object source, String newText) {
                DirectValidationField.this.onTextChanged();
            }
        });
    }

    protected void initDefaultColors() {
        this.defaultForeground = this.getForeground();
        this.defaultBackground = this.getBackground();
        this.errorForegroundEnabled = Color.WHITE;
        this.errorForegroundDisabled = Color.WHITE;
        this.errorBackgroundEnabled = Color.RED;
        this.errorBackgroundDisabled = new Color(127, 127, 127);
    }

    protected void onTextChanged() {
        String text = this.getText();
        if (text.equals(this.lastText)) {
            return;
        }
        this.lastText = text;
        boolean colored = false;
        if (this.isValid(text)) {
            colored = true;
            this.setForeground(this.defaultForeground);
            this.setBackground(this.defaultBackground);
            this.onValidTextEntered(text);
        }
        if (!colored) {
            if (this.isEnabled()) {
                this.setForeground(this.errorForegroundEnabled);
                this.setBackground(this.errorBackgroundEnabled);
            } else {
                this.setForeground(this.errorForegroundDisabled);
                this.setBackground(this.errorBackgroundDisabled);
            }
        }
    }

    protected abstract boolean isValid(String var1);

    protected abstract void onValidTextEntered(String var1);

    public Color getDefaultForeground() {
        return this.defaultForeground;
    }

    public Color getDefaultBackground() {
        return this.defaultBackground;
    }

    public Color getErrorForegroundEnabled() {
        return this.errorForegroundEnabled;
    }

    public Color getErrorForegroundDisabled() {
        return this.errorForegroundDisabled;
    }

    public Color getErrorBackgroundEnabled() {
        return this.errorBackgroundEnabled;
    }

    public Color getErrorBackgroundDisabled() {
        return this.errorBackgroundDisabled;
    }

    public void setDefaultForeground(Color defaultForeground) {
        this.defaultForeground = defaultForeground;
    }

    public void setDefaultBackground(Color defaultBackground) {
        this.defaultBackground = defaultBackground;
    }

    public void setErrorForegroundEnabled(Color errorForegroundEnabled) {
        this.errorForegroundEnabled = errorForegroundEnabled;
    }

    public void setErrorForegroundDisabled(Color errorForegroundDisabled) {
        this.errorForegroundDisabled = errorForegroundDisabled;
    }

    public void setErrorBackgroundEnabled(Color errorBackgroundEnabled) {
        this.errorBackgroundEnabled = errorBackgroundEnabled;
    }

    public void setErrorBackgroundDisabled(Color errorBackgroundDisabled) {
        this.errorBackgroundDisabled = errorBackgroundDisabled;
    }
}

