/*
 * Decompiled with CFR 0.152.
 */
package timon.common.components;

import java.util.ArrayList;
import java.util.List;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import timon.common.components.TTextField;
import timon.common.components.TextChangeListener;

public class DirectTextField
extends TTextField {
    private List<TextChangeListener> changeListeners = new ArrayList<TextChangeListener>();

    public DirectTextField() {
        this(null, null, 0);
    }

    public DirectTextField(int columns) {
        this(null, null, columns);
    }

    public DirectTextField(String text) {
        this(null, text, 0);
    }

    public DirectTextField(String text, int columns) {
        this(null, text, columns);
    }

    public DirectTextField(Document doc, String text, int columns) {
        super(doc, text, columns);
    }

    protected void onTyped(DocumentEvent e) {
        if (!this.isEnabled()) {
            return;
        }
        final String text = this.getText();
        final TextChangeListener[] listeners = new TextChangeListener[this.changeListeners.size()];
        this.changeListeners.toArray(listeners);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                TextChangeListener[] textChangeListenerArray = listeners;
                int n = listeners.length;
                int n2 = 0;
                while (n2 < n) {
                    TextChangeListener tcl = textChangeListenerArray[n2];
                    tcl.textChanged(DirectTextField.this, text);
                    ++n2;
                }
            }
        });
    }

    protected String filter(int offset, String text) {
        return text;
    }

    public void addTextChangeListener(TextChangeListener tcl) {
        this.changeListeners.add(tcl);
    }

    public void removeTextChangeListener(TextChangeListener tcl) {
        this.changeListeners.remove(tcl);
    }

    public void setDocument(Document d) {
        super.setDocument(d);
        d.addDocumentListener(new DocumentListener(){

            public void changedUpdate(DocumentEvent e) {
                DirectTextField.this.onTyped(e);
            }

            public void insertUpdate(DocumentEvent e) {
                DirectTextField.this.onTyped(e);
            }

            public void removeUpdate(DocumentEvent e) {
                DirectTextField.this.onTyped(e);
            }
        });
    }

    public void setText(String text) {
        if (text == null) {
            text = "";
        }
        if (text.equals(this.getText())) {
            return;
        }
        super.setText(text);
    }
}

