/*
 * Decompiled with CFR 0.152.
 */
package timon.common.components;

import java.awt.Color;
import javax.swing.JSpinner;
import javax.swing.SpinnerModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import timon.common.components.DirectTextField;
import timon.common.components.TextChangeListener;

public class DirectSpinner
extends JSpinner {
    private Color foreground;
    private Color background;

    public DirectSpinner() {
        this.createEditor();
    }

    public DirectSpinner(SpinnerModel model) {
        super(model);
        this.createEditor();
    }

    protected void createEditor() {
        final DirectTextField editor = new DirectTextField();
        editor.setText(this.getValue().toString());
        editor.addTextChangeListener(new TextChangeListener(){

            public void textChanged(Object source, String newText) {
                if (DirectSpinner.this.foreground != null && DirectSpinner.this.background != null) {
                    editor.setForeground(DirectSpinner.this.foreground);
                    editor.setBackground(DirectSpinner.this.background);
                }
                if (DirectSpinner.this.getModel() instanceof SpinnerNumberModel) {
                    SpinnerNumberModel model = (SpinnerNumberModel)DirectSpinner.this.getModel();
                    Number value = null;
                    try {
                        if (model.getNumber() instanceof Integer) {
                            value = Integer.decode(editor.getText());
                        } else if (model.getNumber() instanceof Float) {
                            value = Float.valueOf(editor.getText());
                        } else if (model.getNumber() instanceof Double) {
                            value = Double.valueOf(editor.getText());
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                    Comparable<?> minimum = model.getMinimum();
                    Comparable<?> maximum = model.getMaximum();
                    if (value != null && value.compareTo(minimum) >= 0 && value.compareTo(maximum) <= 0) {
                        DirectSpinner.this.setValue(value);
                        editor.setText(DirectSpinner.this.getValue().toString());
                    } else {
                        if (DirectSpinner.this.foreground == null && DirectSpinner.this.background == null) {
                            DirectSpinner.this.foreground = editor.getForeground();
                            DirectSpinner.this.background = editor.getBackground();
                        }
                        editor.setBackground(Color.RED);
                        editor.setForeground(Color.WHITE);
                    }
                } else {
                    DirectSpinner.this.setValue(editor.getText());
                }
            }
        });
        this.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                editor.setText(DirectSpinner.this.getValue().toString());
            }
        });
        this.setEditor(editor);
    }
}

