/*
 * Decompiled with CFR 0.152.
 */
package timon.common.components;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.DefaultButtonModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import timon.common.internal.Icons;

public class ComboButton
extends JPanel {
    private AbstractButton button = this.createButton();
    private AbstractButton dropDownButton;
    private JPopupMenu popup;
    private Action[] actions;
    private boolean useContinuousSelection;
    private int maxArmed;
    private int disableInput;
    private boolean popupVisible;

    public ComboButton() {
        this("", null);
    }

    public ComboButton(String text, Icon icon) {
        this.button.setText(text);
        if (icon != null) {
            this.button.setIcon(icon);
        }
        this.popup = this.createPopup();
        this.popup.addPopupMenuListener(new PopupMenuListener(){

            public void popupMenuCanceled(PopupMenuEvent e) {
                ComboButton.this.popupVisible = false;
                ComboButton.this.dropDownButton.repaint();
            }

            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                ComboButton.this.popupVisible = false;
                ComboButton.this.dropDownButton.repaint();
                ComboButton.this.popup.removeAll();
                if (ComboButton.this.dropDownButton.isEnabled()) {
                    ComboButton comboButton = ComboButton.this;
                    comboButton.disableInput = comboButton.disableInput + 1;
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            ComboButton comboButton = ComboButton.this;
                            comboButton.disableInput = comboButton.disableInput - 1;
                        }
                    });
                }
            }

            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                if (ComboButton.this.actions != null && ComboButton.this.actions.length > 0) {
                    ComboButton.this.maxArmed = -1;
                    ComboButton.this.popupVisible = true;
                    ComboButton.this.button.repaint();
                    JMenuItem[] items = new JMenuItem[ComboButton.this.actions.length];
                    int n = 0;
                    while (n < ComboButton.this.actions.length) {
                        Action a = ComboButton.this.actions[n];
                        if (a != null) {
                            final int x = n;
                            items[x] = new JMenuItem(a){

                                public void setArmed(boolean a) {
                                    if (a) {
                                        ComboButton.this.maxArmed = x;
                                    }
                                    super.setArmed(a);
                                    ComboButton.this.popup.repaint();
                                }
                            };
                            items[x].setModel(new DefaultButtonModel(){

                                public boolean isArmed() {
                                    if (ComboButton.this.useContinuousSelection) {
                                        return ComboButton.this.maxArmed >= x;
                                    }
                                    return super.isArmed();
                                }
                            });
                            ComboButton.this.popup.add(items[n]);
                            if (n < ComboButton.this.actions.length - 1) {
                                ComboButton.this.popup.add(Box.createVerticalStrut(2));
                            }
                        } else {
                            ComboButton.this.popup.addSeparator();
                        }
                        ++n;
                    }
                }
            }
        });
        this.dropDownButton = this.createDropDownButton();
        this.dropDownButton.setModel(new DefaultButtonModel(){
            private boolean armed;
            private boolean enabled;

            public boolean isArmed() {
                return ComboButton.this.popupVisible || this.armed;
            }

            public boolean isPressed() {
                return ComboButton.this.popupVisible || super.isPressed();
            }

            public boolean isEnabled() {
                return ComboButton.this.disableInput == 0 && this.enabled;
            }

            public void setArmed(boolean a) {
                this.armed = a;
            }

            public void setEnabled(boolean e) {
                this.enabled = e;
            }
        });
        this.dropDownButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                if (ComboButton.this.disableInput == 0 && ComboButton.this.actions != null && ComboButton.this.actions.length > 0 && !ComboButton.this.popup.isVisible()) {
                    int x = ComboButton.this.dropDownButton.getWidth() - ((ComboButton)ComboButton.this).popup.getPreferredSize().width;
                    ComboButton.this.popup.show(ComboButton.this.dropDownButton, x, ComboButton.this.dropDownButton.getHeight());
                }
            }
        });
        this.setOpaque(false);
        this.setBackground(new Color(0, 0, 0, 0));
        this.setLayout(null);
        this.add(this.button);
        this.button.setBounds(0, 0, 23, 23);
        this.add(this.dropDownButton);
        this.dropDownButton.setBounds(20, 0, 15, 23);
        this.setPreferredSize(new Dimension(this.dropDownButton.getBounds().x + this.dropDownButton.getWidth(), 23));
        this.setMinimumSize(this.getPreferredSize());
        this.setMaximumSize(this.getPreferredSize());
    }

    protected AbstractButton createButton() {
        JButton button = new JButton();
        return button;
    }

    protected AbstractButton createDropDownButton() {
        JButton button = new JButton(Icons.get("dropdownArrowImage"));
        return button;
    }

    protected JPopupMenu createPopup() {
        JPopupMenu popup = new JPopupMenu();
        popup.setMinimumSize(new Dimension(200, 20));
        return popup;
    }

    public AbstractButton getButton() {
        return this.button;
    }

    public Action getButtonAction() {
        return this.button.getAction();
    }

    public String getToolTipText() {
        return this.button.getToolTipText();
    }

    public Point getToolTipLocation(MouseEvent event) {
        return this.button.getToolTipLocation(event);
    }

    public String getToolTipText(MouseEvent event) {
        return this.button.getToolTipText(event);
    }

    public boolean isGetContinuousSelection() {
        return this.useContinuousSelection;
    }

    public void setToolTipText(String text) {
        this.button.setToolTipText(text);
    }

    public void setEnabled(boolean e) {
        super.setEnabled(e);
        this.button.setEnabled(e);
        this.dropDownButton.setEnabled(e);
    }

    public void setButtonAction(Action action) {
        Icon icon = this.button.getIcon();
        String text = this.button.getText();
        this.button.setAction(action);
        this.button.setIcon(icon);
        this.button.setText(text);
    }

    public void setDropDownActions(Action[] actions) {
        this.actions = actions;
    }

    public void setUseContinuousSelection(boolean useContinuousSelection) {
        this.useContinuousSelection = useContinuousSelection;
    }
}

